/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.SeekBarProgressChange;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.OnSeekBarChangeListenerHolder;
import org.androidannotations.internal.core.handler.CoreBaseAnnotationHandler;
import org.androidannotations.rclass.IRClass;

public class SeekBarProgressChangeHandler
extends CoreBaseAnnotationHandler<EComponentWithViewSupportHolder> {
    public SeekBarProgressChangeHandler(AndroidAnnotationsEnvironment environment) {
        super(SeekBarProgressChange.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, validation);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, validation);
        this.validatorHelper.isNotPrivate(element, validation);
        this.validatorHelper.doesntThrowException(element, validation);
        this.validatorHelper.returnTypeIsVoid((ExecutableElement)element, validation);
        this.coreValidatorHelper.hasSeekBarProgressChangeMethodParameters((ExecutableElement)element, validation);
    }

    @Override
    public void process(Element element, EComponentWithViewSupportHolder holder) throws Exception {
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        int seekBarViewParameterPosition = -1;
        int progressParameterPosition = -1;
        int fromUserParameterPosition = -1;
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            TypeMirror parameterType = parameter.asType();
            if ("android.widget.SeekBar".equals(parameterType.toString())) {
                seekBarViewParameterPosition = i;
                continue;
            }
            if (parameterType.getKind() == TypeKind.INT || CanonicalNameConstants.INTEGER.equals(parameterType.toString())) {
                progressParameterPosition = i;
                continue;
            }
            if (parameterType.getKind() != TypeKind.BOOLEAN && !CanonicalNameConstants.BOOLEAN.equals(parameterType.toString())) continue;
            fromUserParameterPosition = i;
        }
        List<JFieldRef> idsRefs = this.annotationHelper.extractAnnotationFieldRefs(element, IRClass.Res.ID, true);
        for (JFieldRef idRef : idsRefs) {
            OnSeekBarChangeListenerHolder onSeekBarChangeListenerHolder = holder.getOnSeekBarChangeListenerHolder(idRef);
            JBlock methodBody = onSeekBarChangeListenerHolder.getOnProgressChangedBody();
            JFieldRef activityRef = holder.getGeneratedClass().staticRef("this");
            JInvocation textChangeCall = methodBody.invoke((IJExpression)activityRef, methodName);
            for (int i = 0; i < parameters.size(); ++i) {
                if (i == seekBarViewParameterPosition) {
                    JVar seekBarViewParameter = onSeekBarChangeListenerHolder.getOnProgressChangedSeekBarParam();
                    textChangeCall.arg((IJExpression)seekBarViewParameter);
                    continue;
                }
                if (i == progressParameterPosition) {
                    JVar progressParameter = onSeekBarChangeListenerHolder.getOnProgressChangedProgressParam();
                    textChangeCall.arg((IJExpression)progressParameter);
                    continue;
                }
                if (i != fromUserParameterPosition) continue;
                JVar fromUserParameter = onSeekBarChangeListenerHolder.getOnProgressChangedFromUserParam();
                textChangeCall.arg((IJExpression)fromUserParameter);
            }
        }
    }
}

