/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JConditional;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JInvocation;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.RootContext;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.InjectHelper;
import org.androidannotations.helper.LogHelper;
import org.androidannotations.holder.EBeanHolder;

public class RootContextHandler
extends BaseAnnotationHandler<EBeanHolder>
implements MethodInjectionHandler<EBeanHolder> {
    private final InjectHelper<EBeanHolder> injectHelper;

    public RootContextHandler(AndroidAnnotationsEnvironment environment) {
        super(RootContext.class, environment);
        this.injectHelper = new InjectHelper<EBeanHolder>(this.validatorHelper, this);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.injectHelper.validate(RootContext.class, element, validation);
        if (!validation.isValid()) {
            return;
        }
        Element param = this.injectHelper.getParam(element);
        this.validatorHelper.extendsContext(param, validation);
        this.validatorHelper.isNotPrivate(element, validation);
    }

    @Override
    public void process(Element element, EBeanHolder holder) {
        this.injectHelper.process(element, holder);
    }

    @Override
    public JBlock getInvocationBlock(EBeanHolder holder) {
        return holder.getInitBodyInjectionBlock();
    }

    @Override
    public void assignValue(JBlock targetBlock, IJAssignmentTarget fieldRef, EBeanHolder holder, Element element, Element param) {
        TypeMirror elementType = param.asType();
        String typeQualifiedName = elementType.toString();
        IJExpression contextRef = holder.getContextRef();
        if ("android.content.Context".equals(typeQualifiedName)) {
            targetBlock.add((IJStatement)fieldRef.assign(contextRef));
        } else {
            AbstractJClass extendingContextClass = this.getEnvironment().getJClass(typeQualifiedName);
            JConditional cond = this.getInvocationBlock(holder)._if(holder.getContextRef()._instanceof((AbstractJType)extendingContextClass));
            cond._then().add((IJStatement)fieldRef.assign((IJExpression)JExpr.cast((AbstractJType)extendingContextClass, (IJExpression)holder.getContextRef())));
            JInvocation warningInvoke = this.getClasses().LOG.staticInvoke("w");
            warningInvoke.arg(LogHelper.logTagForClassHolder(holder));
            warningInvoke.arg(JExpr.lit((String)"Due to Context class ").plus((IJExpression)holder.getContextRef().invoke("getClass").invoke("getSimpleName")).plus((IJExpression)JExpr.lit((String)(", the @RootContext " + extendingContextClass.name() + " won't be populated"))));
            cond._else().add((IJStatement)warningInvoke);
        }
    }

    @Override
    public void validateEnclosingElement(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEBeanAnnotation(element, valid);
    }
}

