/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAnonymousClass;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JOp;
import com.helger.jcodemodel.JVar;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.Receiver;
import org.androidannotations.handler.AnnotationHandler;
import org.androidannotations.handler.HasParameterHandlers;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.helper.ValidatorParameterHelper;
import org.androidannotations.holder.EFragmentHolder;
import org.androidannotations.holder.HasActivityLifecycleMethods;
import org.androidannotations.holder.HasReceiverRegistration;
import org.androidannotations.holder.ReceiverRegistrationDelegate;
import org.androidannotations.internal.core.handler.CoreBaseAnnotationHandler;
import org.androidannotations.internal.core.handler.ExtraParameterHandler;

public class ReceiverHandler
extends CoreBaseAnnotationHandler<HasReceiverRegistration>
implements HasParameterHandlers<HasReceiverRegistration> {
    private ExtraHandler extraHandler;

    public ReceiverHandler(AndroidAnnotationsEnvironment environment) {
        super(Receiver.class, environment);
        this.extraHandler = new ExtraHandler(environment);
    }

    @Override
    public Iterable<AnnotationHandler> getParameterHandlers() {
        return Collections.singleton(this.extraHandler);
    }

    @Override
    protected void validate(Element element, ElementValidation validation) {
        this.validatorHelper.enclosingElementHasEActivityOrEFragmentOrEServiceOrEIntentServiceOrEViewOrEViewGroup(element, validation);
        this.validatorHelper.isNotPrivate(element, validation);
        this.validatorHelper.returnTypeIsVoid((ExecutableElement)element, validation);
        ((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)this.validatorHelper.param.anyOrder().type("android.content.Context")).optional()).type("android.content.Intent")).optional()).annotatedWith(Receiver.Extra.class)).multiple()).optional()).validate((ExecutableElement)element, validation);
        this.validatorHelper.hasNotMultipleAnnotatedMethodWithSameName(element.getEnclosingElement(), validation, Receiver.class);
        this.coreValidatorHelper.hasRightRegisterAtValueDependingOnEnclosingElement(element, validation);
        this.coreValidatorHelper.hasSupportV4JarIfLocal(element, validation);
    }

    @Override
    public void process(Element element, HasReceiverRegistration holder) throws Exception {
        String methodName = element.getSimpleName().toString();
        String receiverName = methodName + "Receiver" + ModelConstants.generationSuffix();
        Receiver annotation = element.getAnnotation(Receiver.class);
        String[] actions = annotation.actions();
        String[] dataSchemes = annotation.dataSchemes();
        Receiver.RegisterAt registerAt = annotation.registerAt();
        boolean local = annotation.local();
        JFieldVar intentFilterField = holder.getIntentFilterField(new ReceiverRegistrationDelegate.IntentFilterData(actions, dataSchemes, registerAt));
        JFieldVar receiverField = this.createReceiverField(holder, receiverName, methodName, (ExecutableElement)element);
        this.registerAndUnregisterReceiver(holder, registerAt, intentFilterField, receiverField, local);
    }

    private JFieldVar createReceiverField(HasReceiverRegistration holder, String receiverName, String methodName, ExecutableElement executableElement) {
        JAnonymousClass anonymousReceiverClass = this.getCodeModel().anonymousClass(this.getClasses().BROADCAST_RECEIVER);
        JMethod onReceiveMethod = anonymousReceiverClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onReceive");
        JVar contextVar = onReceiveMethod.param((AbstractJType)this.getClasses().CONTEXT, "context");
        JVar intentVar = onReceiveMethod.param((AbstractJType)this.getClasses().INTENT, "intent");
        JBlock body = onReceiveMethod.body();
        JFieldRef receiverRef = holder.getGeneratedClass().staticRef("this");
        JInvocation methodCall = receiverRef.invoke(methodName);
        JVar extras = null;
        List<? extends VariableElement> methodParameters = executableElement.getParameters();
        for (VariableElement variableElement : methodParameters) {
            AbstractJClass extraParamClass = this.codeModelHelper.typeMirrorToJClass(variableElement.asType());
            if (extraParamClass.equals(this.getClasses().CONTEXT)) {
                methodCall.arg((IJExpression)contextVar);
                continue;
            }
            if (extraParamClass.equals(this.getClasses().INTENT) && variableElement.getAnnotation(Receiver.Extra.class) == null) {
                methodCall.arg((IJExpression)intentVar);
                continue;
            }
            if (variableElement.getAnnotation(Receiver.Extra.class) == null) continue;
            if (extras == null) {
                extras = body.decl((AbstractJType)this.getClasses().BUNDLE, "extras_", (IJExpression)JOp.cond((IJExpression)intentVar.invoke("getExtras").ne((IJExpression)JExpr._null()), (IJExpression)intentVar.invoke("getExtras"), (IJExpression)JExpr._new((AbstractJClass)this.getClasses().BUNDLE)));
            }
            methodCall.arg(this.extraHandler.getExtraValue(variableElement, extras, body, onReceiveMethod, (JDefinedClass)anonymousReceiverClass));
        }
        body.add((IJStatement)methodCall);
        JInvocation receiverInit = JExpr._new((AbstractJClass)anonymousReceiverClass);
        return holder.getGeneratedClass().field(12, (AbstractJType)this.getClasses().BROADCAST_RECEIVER, receiverName, (IJExpression)receiverInit);
    }

    private void registerAndUnregisterReceiver(HasReceiverRegistration holder, Receiver.RegisterAt registerAt, JFieldVar intentFilterField, JFieldVar receiverField, boolean local) {
        JBlock registerBlock = null;
        JBlock unregisterBlock = null;
        if (holder instanceof HasActivityLifecycleMethods) {
            HasActivityLifecycleMethods activityLifecycleMethods = (HasActivityLifecycleMethods)((Object)holder);
            switch (registerAt) {
                case OnCreateOnDestroy: {
                    registerBlock = activityLifecycleMethods.getOnCreateAfterSuperBlock();
                    unregisterBlock = activityLifecycleMethods.getOnDestroyBeforeSuperBlock();
                    break;
                }
                case OnStartOnStop: {
                    registerBlock = activityLifecycleMethods.getOnStartAfterSuperBlock();
                    unregisterBlock = activityLifecycleMethods.getOnStopBeforeSuperBlock();
                    break;
                }
                case OnResumeOnPause: {
                    registerBlock = activityLifecycleMethods.getOnResumeAfterSuperBlock();
                    unregisterBlock = activityLifecycleMethods.getOnPauseBeforeSuperBlock();
                }
            }
            if (holder instanceof EFragmentHolder && registerAt == Receiver.RegisterAt.OnAttachOnDetach) {
                EFragmentHolder fragmentHolder = (EFragmentHolder)holder;
                registerBlock = fragmentHolder.getOnAttachAfterSuperBlock();
                unregisterBlock = fragmentHolder.getOnDetachBeforeSuperBlock();
            }
        } else {
            registerBlock = holder.getStartLifecycleAfterSuperBlock();
            unregisterBlock = holder.getEndLifecycleBeforeSuperBlock();
        }
        Object broadcastManager = local ? (this.getProcessingEnvironment().getElementUtils().getTypeElement("android.support.v4.content.LocalBroadcastManager") == null ? this.getClasses().ANDROIDX_LOCAL_BROADCAST_MANAGER.staticInvoke("getInstance").arg(holder.getContextRef()) : this.getClasses().LOCAL_BROADCAST_MANAGER.staticInvoke("getInstance").arg(holder.getContextRef())) : holder.getContextRef();
        registerBlock.invoke(broadcastManager, "registerReceiver").arg((IJExpression)receiverField).arg((IJExpression)intentFilterField);
        unregisterBlock.invoke(broadcastManager, "unregisterReceiver").arg((IJExpression)receiverField);
    }

    private static class ExtraHandler
    extends ExtraParameterHandler {
        ExtraHandler(AndroidAnnotationsEnvironment environment) {
            super(Receiver.Extra.class, Receiver.class, environment);
        }

        @Override
        public String getAnnotationValue(VariableElement parameter) {
            return parameter.getAnnotation(Receiver.Extra.class).value();
        }
    }
}

