/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JNarrowedClass;
import com.helger.jcodemodel.JOp;
import com.helger.jcodemodel.JVar;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.ReceiverAction;
import org.androidannotations.handler.AnnotationHandler;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.HasParameterHandlers;
import org.androidannotations.helper.CaseHelper;
import org.androidannotations.helper.ValidatorParameterHelper;
import org.androidannotations.holder.EReceiverHolder;
import org.androidannotations.internal.core.handler.ExtraParameterHandler;

public class ReceiverActionHandler
extends BaseAnnotationHandler<EReceiverHolder>
implements HasParameterHandlers<EReceiverHolder> {
    private ExtraHandler extraHandler;

    public ReceiverActionHandler(AndroidAnnotationsEnvironment environment) {
        super(ReceiverAction.class, environment);
        this.extraHandler = new ExtraHandler(environment);
    }

    @Override
    public Iterable<AnnotationHandler> getParameterHandlers() {
        return Collections.singleton(this.extraHandler);
    }

    @Override
    protected void validate(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEReceiver(element, valid);
        this.validatorHelper.returnTypeIsVoid((ExecutableElement)element, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        ((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)this.validatorHelper.param.anyOrder().type("android.content.Context")).optional()).type("android.content.Intent")).optional()).annotatedWith(ReceiverAction.Extra.class)).multiple()).optional()).validate((ExecutableElement)element, valid);
    }

    @Override
    public void process(Element element, EReceiverHolder holder) throws Exception {
        ExecutableElement executableElement = (ExecutableElement)element;
        String methodName = element.getSimpleName().toString();
        ReceiverAction annotation = element.getAnnotation(ReceiverAction.class);
        String[] dataSchemes = annotation.dataSchemes();
        String[] actions = annotation.actions();
        JFieldVar actionKeyField = this.createStaticField(holder, "actions", methodName, actions);
        JFieldVar dataSchemesField = this.createStaticField(holder, "dataSchemes", methodName, dataSchemes);
        this.addActionInOnReceive(holder, executableElement, methodName, actionKeyField, dataSchemesField);
    }

    private JFieldVar createStaticField(EReceiverHolder holder, String prefix, String methodName, String[] values) {
        String staticFieldName = CaseHelper.camelCaseToUpperSnakeCase(prefix, methodName, null);
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return holder.getGeneratedClass().field(25, (AbstractJType)this.getClasses().STRING, staticFieldName, (IJExpression)JExpr.lit((String)values[0]));
        }
        JInvocation asListInvoke = this.getClasses().ARRAYS.staticInvoke("asList");
        for (String scheme : values) {
            asListInvoke.arg(scheme);
        }
        JNarrowedClass listOfStrings = this.getClasses().LIST.narrow(this.getClasses().STRING);
        return holder.getGeneratedClass().field(25, (AbstractJType)listOfStrings, staticFieldName, (IJExpression)asListInvoke);
    }

    private void addActionInOnReceive(EReceiverHolder holder, ExecutableElement executableElement, String methodName, JFieldVar actionsField, JFieldVar dataSchemesField) {
        String actionsInvoke = this.getInvocationName(actionsField);
        JInvocation filterCondition = actionsField.invoke(actionsInvoke).arg((IJExpression)holder.getOnReceiveIntentAction());
        if (dataSchemesField != null) {
            String dataSchemesInvoke = this.getInvocationName(dataSchemesField);
            filterCondition = filterCondition.cand((IJExpression)dataSchemesField.invoke(dataSchemesInvoke).arg((IJExpression)holder.getOnReceiveIntentDataScheme()));
        }
        JBlock callActionBlock = holder.getOnReceiveBody()._if((IJExpression)filterCondition)._then();
        JFieldRef receiverRef = holder.getGeneratedClass().staticRef("this");
        JInvocation callActionInvocation = receiverRef.invoke(methodName);
        JVar intent = holder.getOnReceiveIntent();
        JVar extras = null;
        List<? extends VariableElement> methodParameters = executableElement.getParameters();
        for (VariableElement variableElement : methodParameters) {
            AbstractJClass extraParamClass = this.codeModelHelper.typeMirrorToJClass(variableElement.asType());
            if (extraParamClass.equals(this.getClasses().CONTEXT)) {
                callActionInvocation.arg((IJExpression)holder.getOnReceiveContext());
                continue;
            }
            if (extraParamClass.equals(this.getClasses().INTENT) && variableElement.getAnnotation(ReceiverAction.Extra.class) == null) {
                callActionInvocation.arg((IJExpression)intent);
                continue;
            }
            if (variableElement.getAnnotation(ReceiverAction.Extra.class) == null) continue;
            if (extras == null) {
                extras = callActionBlock.decl((AbstractJType)this.getClasses().BUNDLE, "extras_", (IJExpression)JOp.cond((IJExpression)intent.invoke("getExtras").ne((IJExpression)JExpr._null()), (IJExpression)intent.invoke("getExtras"), (IJExpression)JExpr._new((AbstractJClass)this.getClasses().BUNDLE)));
            }
            callActionInvocation.arg(this.extraHandler.getExtraValue(variableElement, extras, callActionBlock, holder));
        }
        callActionBlock.add((IJStatement)callActionInvocation);
        callActionBlock._return();
    }

    private String getInvocationName(JFieldVar field) {
        JNarrowedClass listOfStrings = this.getClasses().LIST.narrow(this.getClasses().STRING);
        if (field.type().fullName().equals(listOfStrings.fullName())) {
            return "contains";
        }
        return "equals";
    }

    private static class ExtraHandler
    extends ExtraParameterHandler {
        ExtraHandler(AndroidAnnotationsEnvironment environment) {
            super(ReceiverAction.Extra.class, ReceiverAction.class, environment);
        }

        @Override
        public String getAnnotationValue(VariableElement parameter) {
            return parameter.getAnnotation(ReceiverAction.Extra.class).value();
        }

        public IJExpression getExtraValue(VariableElement parameter, JVar extras, JBlock block, EReceiverHolder holder) {
            return this.getExtraValue(parameter, extras, block, holder.getOnReceiveMethod(), holder);
        }
    }
}

