/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JFieldRef;
import javax.lang.model.element.Element;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.PreferenceScreen;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.HasPreferences;
import org.androidannotations.rclass.IRClass;

public class PreferenceScreenHandler
extends BaseAnnotationHandler<HasPreferences> {
    public PreferenceScreenHandler(AndroidAnnotationsEnvironment environment) {
        super(PreferenceScreen.class, environment);
    }

    @Override
    protected void validate(Element element, ElementValidation valid) {
        this.validatorHelper.extendsPreferenceActivityOrPreferenceFragment(element, valid);
        this.validatorHelper.hasEActivityOrEFragment(element, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.XML, IdValidatorHelper.FallbackStrategy.NEED_RES_ID, valid);
    }

    @Override
    public void process(Element element, HasPreferences holder) throws Exception {
        JFieldRef preferenceId = this.annotationHelper.extractAnnotationFieldRefs(element, IRClass.Res.XML, false).get(0);
        holder.getPreferenceScreenInitializationBlock().invoke("addPreferencesFromResource").arg((IJExpression)preferenceId);
    }
}

