/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JVar;
import javax.lang.model.element.Element;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.PreferenceHeaders;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.HasPreferenceHeaders;
import org.androidannotations.rclass.IRClass;

public class PreferenceHeadersHandler
extends BaseAnnotationHandler<HasPreferenceHeaders> {
    public PreferenceHeadersHandler(AndroidAnnotationsEnvironment environment) {
        super(PreferenceHeaders.class, environment);
    }

    @Override
    protected void validate(Element element, ElementValidation valid) {
        this.validatorHelper.isPreferenceFragmentClassPresent(element, valid);
        this.validatorHelper.extendsPreferenceActivity(element, valid);
        this.validatorHelper.hasEActivity(element, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.XML, IdValidatorHelper.FallbackStrategy.NEED_RES_ID, valid);
    }

    @Override
    public void process(Element element, HasPreferenceHeaders holder) throws Exception {
        JFieldRef headerId = this.annotationHelper.extractAnnotationFieldRefs(element, IRClass.Res.XML, false).get(0);
        JBlock block = holder.getOnBuildHeadersBlock();
        JVar targetParam = holder.getOnBuildHeadersTargetParam();
        block.invoke("loadHeadersFromResource").arg((IJExpression)headerId).arg((IJExpression)targetParam);
        block.invoke((IJExpression)JExpr._super(), "onBuildHeaders").arg((IJExpression)targetParam);
    }
}

