/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.PreferenceClick;
import org.androidannotations.holder.HasPreferences;
import org.androidannotations.internal.core.handler.AbstractPreferenceListenerHandler;

public class PreferenceClickHandler
extends AbstractPreferenceListenerHandler {
    public PreferenceClickHandler(AndroidAnnotationsEnvironment environment) {
        super(PreferenceClick.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation valid) {
        super.validate(element, valid);
        this.validatorHelper.enclosingElementExtendsPreferenceActivityOrPreferenceFragment(element, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoidOrBoolean(executableElement, valid);
        this.validatorHelper.param.extendsAnyOfTypes("android.preference.Preference", "android.support.v7.preference.Preference", "androidx.preference.Preference").optional().validate(executableElement, valid);
    }

    @Override
    protected void makeCall(JBlock listenerMethodBody, JInvocation call, TypeMirror returnType) {
        boolean returnMethodResult;
        boolean bl = returnMethodResult = returnType.getKind() != TypeKind.VOID;
        if (returnMethodResult) {
            listenerMethodBody._return((IJExpression)call);
        } else {
            listenerMethodBody.add((IJStatement)call);
            listenerMethodBody._return((IJExpression)JExpr.TRUE);
        }
    }

    @Override
    protected void processParameters(HasPreferences holder, JMethod listenerMethod, JInvocation call, List<? extends VariableElement> userParameters) {
        String preferenceClassName = holder.getBasePreferenceClass().fullName();
        JVar preferenceParam = listenerMethod.param((AbstractJType)this.getEnvironment().getJClass(preferenceClassName), "preference");
        if (userParameters.size() == 1) {
            call.arg(this.castArgumentIfNecessary(holder, preferenceClassName, preferenceParam, userParameters.get(0)));
        }
    }

    @Override
    protected JMethod createListenerMethod(JDefinedClass listenerAnonymousClass) {
        return listenerAnonymousClass.method(1, (AbstractJType)this.getCodeModel().BOOLEAN, "onPreferenceClick");
    }

    @Override
    protected String getSetterName() {
        return "setOnPreferenceClickListener";
    }

    @Override
    protected AbstractJClass getListenerClass(HasPreferences holder) {
        return holder.usingAndroidxPreference() ? this.getClasses().ANDROIDX_PREFERENCE_CLICK_LISTENER : (holder.usingSupportV7Preference() ? this.getClasses().SUPPORT_V7_PREFERENCE_CLICK_LISTENER : this.getClasses().PREFERENCE_CLICK_LISTENER);
    }
}

