/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.PreferenceChange;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.ValidatorParameterHelper;
import org.androidannotations.holder.HasPreferences;
import org.androidannotations.internal.core.handler.AbstractPreferenceListenerHandler;

public class PreferenceChangeHandler
extends AbstractPreferenceListenerHandler {
    public PreferenceChangeHandler(AndroidAnnotationsEnvironment environment) {
        super(PreferenceChange.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation valid) {
        super.validate(element, valid);
        this.validatorHelper.enclosingElementExtendsPreferenceActivityOrPreferenceFragment(element, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoidOrBoolean(executableElement, valid);
        ((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)this.validatorHelper.param.anyOrder().extendsAnyOfTypes("android.preference.Preference", "android.support.v7.preference.Preference", "androidx.preference.Preference")).optional()).anyOfTypes(CanonicalNameConstants.OBJECT, "java.util.Set<java.lang.String>", CanonicalNameConstants.STRING, CanonicalNameConstants.BOOLEAN, Boolean.TYPE.getName(), CanonicalNameConstants.INTEGER, Integer.TYPE.getName(), CanonicalNameConstants.LONG, Long.TYPE.getName(), CanonicalNameConstants.FLOAT, Float.TYPE.getName())).optional()).validate(executableElement, valid);
    }

    @Override
    protected void makeCall(JBlock listenerMethodBody, JInvocation call, TypeMirror returnType) {
        boolean returnMethodResult;
        boolean bl = returnMethodResult = returnType.getKind() != TypeKind.VOID;
        if (returnMethodResult) {
            listenerMethodBody._return((IJExpression)call);
        } else {
            listenerMethodBody.add((IJStatement)call);
            listenerMethodBody._return((IJExpression)JExpr.TRUE);
        }
    }

    @Override
    protected void processParameters(HasPreferences holder, JMethod listenerMethod, JInvocation call, List<? extends VariableElement> userParameters) {
        JVar preferenceParam = listenerMethod.param((AbstractJType)holder.getBasePreferenceClass(), "preference");
        JVar newValueParam = listenerMethod.param((AbstractJType)this.getClasses().OBJECT, "newValue");
        for (VariableElement variableElement : userParameters) {
            String type = variableElement.asType().toString();
            if (this.isTypeOrSubclass("android.preference.Preference", variableElement)) {
                call.arg(this.castArgumentIfNecessary(holder, "android.preference.Preference", preferenceParam, variableElement));
                continue;
            }
            if (this.isTypeOrSubclass("android.support.v7.preference.Preference", variableElement)) {
                call.arg(this.castArgumentIfNecessary(holder, "android.support.v7.preference.Preference", preferenceParam, variableElement));
                continue;
            }
            if (this.isTypeOrSubclass("androidx.preference.Preference", variableElement)) {
                call.arg(this.castArgumentIfNecessary(holder, "androidx.preference.Preference", preferenceParam, variableElement));
                continue;
            }
            if (type.equals(CanonicalNameConstants.OBJECT)) {
                call.arg((IJExpression)newValueParam);
                continue;
            }
            if (type.equals(CanonicalNameConstants.INTEGER) || type.equals(Integer.TYPE.getName()) || type.equals(CanonicalNameConstants.FLOAT) || type.equals(Float.TYPE.getName()) || type.equals(CanonicalNameConstants.LONG) || type.equals(Long.TYPE.getName())) {
                AbstractJClass wrapperClass = this.getEnvironment().getCodeModel().parseType(type).boxify();
                call.arg((IJExpression)wrapperClass.staticInvoke("valueOf").arg((IJExpression)JExpr.cast((AbstractJType)this.getClasses().STRING, (IJExpression)newValueParam)));
                continue;
            }
            AbstractJClass userParamClass = this.codeModelHelper.typeMirrorToJClass(variableElement.asType());
            call.arg((IJExpression)JExpr.cast((AbstractJType)userParamClass, (IJExpression)newValueParam));
            if (!type.equals("java.util.Set<java.lang.String>")) continue;
            this.codeModelHelper.addSuppressWarnings((IJAnnotatable)listenerMethod, "unchecked");
        }
    }

    @Override
    protected JMethod createListenerMethod(JDefinedClass listenerAnonymousClass) {
        return listenerAnonymousClass.method(1, (AbstractJType)this.getCodeModel().BOOLEAN, "onPreferenceChange");
    }

    @Override
    protected String getSetterName() {
        return "setOnPreferenceChangeListener";
    }

    @Override
    protected AbstractJClass getListenerClass(HasPreferences holder) {
        return holder.usingAndroidxPreference() ? this.getClasses().ANDROIDX_PREFERENCE_CHANGE_LISTENER : (holder.usingSupportV7Preference() ? this.getClasses().SUPPORT_V7_PREFERENCE_CHANGE_LISTENER : this.getClasses().PREFERENCE_CHANGE_LISTENER);
    }
}

