/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JFieldRef;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.PreferenceByKey;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.helper.InjectHelper;
import org.androidannotations.holder.FoundPreferenceHolder;
import org.androidannotations.holder.HasPreferences;
import org.androidannotations.rclass.IRClass;

public class PreferenceByKeyHandler
extends BaseAnnotationHandler<HasPreferences>
implements MethodInjectionHandler<HasPreferences> {
    private final InjectHelper<HasPreferences> injectHelper;

    public PreferenceByKeyHandler(AndroidAnnotationsEnvironment environment) {
        super(PreferenceByKey.class, environment);
        this.injectHelper = new InjectHelper<HasPreferences>(this.validatorHelper, this);
    }

    @Override
    protected void validate(Element element, ElementValidation valid) {
        this.injectHelper.validate(PreferenceByKey.class, element, valid);
        if (!valid.isValid()) {
            return;
        }
        if (element.getKind() == ElementKind.PARAMETER) {
            this.validatorHelper.enclosingElementExtendsPreferenceActivityOrPreferenceFragment(element.getEnclosingElement(), valid);
        } else {
            this.validatorHelper.enclosingElementExtendsPreferenceActivityOrPreferenceFragment(element, valid);
        }
        Element param = this.injectHelper.getParam(element);
        this.validatorHelper.isDeclaredType(param, valid);
        this.validatorHelper.extendsPreference(param, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.STRING, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, valid);
    }

    @Override
    public void process(Element element, HasPreferences holder) throws Exception {
        this.injectHelper.process(element, holder);
    }

    @Override
    public JBlock getInvocationBlock(HasPreferences holder) {
        return holder.getAddPreferencesFromResourceInjectionBlock();
    }

    @Override
    public void assignValue(JBlock targetBlock, IJAssignmentTarget fieldRef, HasPreferences holder, Element element, Element param) {
        FoundPreferenceHolder preferenceHolder;
        TypeMirror prefFieldTypeMirror = param.asType();
        String typeQualifiedName = prefFieldTypeMirror.toString();
        JFieldRef idRef = this.annotationHelper.extractOneAnnotationFieldRef(element, IRClass.Res.STRING, true);
        AbstractJClass preferenceClass = this.getJClass(typeQualifiedName);
        IJAssignmentTarget preferenceHolderTarget = null;
        if (element.getKind() == ElementKind.FIELD) {
            preferenceHolderTarget = fieldRef;
        }
        if (!(preferenceHolder = holder.getFoundPreferenceHolder(idRef, preferenceClass, preferenceHolderTarget)).getRef().equals(preferenceHolderTarget)) {
            targetBlock.add((IJStatement)fieldRef.assign(preferenceHolder.getOrCastRef(preferenceClass)));
        }
    }

    @Override
    public void validateEnclosingElement(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEActivityOrEFragment(element, valid);
    }
}

