/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.sharedpreferences.Pref;
import org.androidannotations.annotations.sharedpreferences.SharedPref;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.InjectHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.internal.core.handler.CoreBaseAnnotationHandler;

public class PrefHandler
extends CoreBaseAnnotationHandler<EComponentHolder>
implements MethodInjectionHandler<EComponentHolder> {
    private final InjectHelper<EComponentHolder> injectHelper;

    public PrefHandler(AndroidAnnotationsEnvironment environment) {
        super(Pref.class, environment);
        this.injectHelper = new InjectHelper<EComponentHolder>(this.validatorHelper, this);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.injectHelper.validate(Pref.class, element, validation);
        if (!validation.isValid()) {
            return;
        }
        this.validatorHelper.isNotPrivate(element, validation);
        this.coreValidatorHelper.isSharedPreference(element, validation);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        this.injectHelper.process(element, holder);
    }

    @Override
    public JBlock getInvocationBlock(EComponentHolder holder) {
        return holder.getInitBodyInjectionBlock();
    }

    @Override
    public void assignValue(JBlock targetBlock, IJAssignmentTarget fieldRef, EComponentHolder holder, Element element, Element param) {
        TypeMirror fieldTypeMirror = param.asType();
        AbstractJClass prefClass = this.getJClass(fieldTypeMirror.toString());
        String elementTypeName = fieldTypeMirror.toString();
        int index = elementTypeName.lastIndexOf(".");
        if (index != -1) {
            elementTypeName = elementTypeName.substring(index + 1);
        }
        Set<? extends Element> sharedPrefElements = this.getEnvironment().getValidatedElements().getRootAnnotatedElements(SharedPref.class.getName());
        for (Element element2 : sharedPrefElements) {
            GeneratedClassHolder sharedPrefHolder = this.getEnvironment().getGeneratedClassHolder(element2);
            String sharedPrefName = sharedPrefHolder.getGeneratedClass().name();
            if (!elementTypeName.equals(sharedPrefName)) continue;
            prefClass = sharedPrefHolder.getGeneratedClass();
            break;
        }
        targetBlock.add((IJStatement)fieldRef.assign((IJExpression)JExpr._new((AbstractJClass)prefClass).arg(holder.getContextRef())));
    }

    @Override
    public void validateEnclosingElement(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, valid);
    }
}

