/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.PageScrolled;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.ValidatorParameterHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.PageChangeHolder;
import org.androidannotations.internal.core.handler.AbstractPageChangeHandler;
import org.androidannotations.rclass.IRClass;

public class PageScrolledHandler
extends AbstractPageChangeHandler {
    public PageScrolledHandler(AndroidAnnotationsEnvironment environment) {
        super(PageScrolled.class, environment);
    }

    @Override
    protected void validate(Element element, ElementValidation validation) {
        super.validate(element, validation);
        ((ValidatorParameterHelper.InOrderParamValidator)((ValidatorParameterHelper.InOrderParamValidator)((ValidatorParameterHelper.InOrderParamValidator)((ValidatorParameterHelper.InOrderParamValidator)((ValidatorParameterHelper.InOrderParamValidator)((ValidatorParameterHelper.InOrderParamValidator)((ValidatorParameterHelper.InOrderParamValidator)((ValidatorParameterHelper.InOrderParamValidator)this.validatorHelper.param.inOrder().anyOfTypes("android.support.v4.view.ViewPager", "androidx.viewpager.widget.ViewPager")).optional()).primitiveOrWrapper(TypeKind.INT)).optional()).primitiveOrWrapper(TypeKind.FLOAT)).optional()).primitiveOrWrapper(TypeKind.INT)).optional()).validate((ExecutableElement)element, validation);
    }

    @Override
    public void process(Element element, EComponentWithViewSupportHolder holder) throws Exception {
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        int positionParameterPosition = -1;
        int positionOffsetParameterPosition = -1;
        int positionOffsetPixelsParameterPosition = -1;
        int viewPagerParameterPosition = -1;
        int numberOfIntParameters = 0;
        TypeMirror viewPagerParameterType = null;
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            TypeMirror parameterType = parameter.asType();
            if (parameterType.getKind() == TypeKind.INT || CanonicalNameConstants.INTEGER.equals(parameterType.toString())) {
                if (numberOfIntParameters == 0 && positionOffsetParameterPosition == -1) {
                    positionParameterPosition = i;
                } else {
                    positionOffsetPixelsParameterPosition = i;
                }
                ++numberOfIntParameters;
                continue;
            }
            if (parameterType.getKind() == TypeKind.FLOAT || CanonicalNameConstants.FLOAT.equals(parameterType.toString())) {
                positionOffsetParameterPosition = i;
                continue;
            }
            if (!this.isViewPagerParameter(parameterType)) continue;
            viewPagerParameterPosition = i;
            viewPagerParameterType = parameterType;
        }
        List<JFieldRef> idsRefs = this.annotationHelper.extractAnnotationFieldRefs(element, IRClass.Res.ID, true);
        for (JFieldRef idRef : idsRefs) {
            PageChangeHolder pageChangeHolder = holder.getPageChangeHolder(idRef, viewPagerParameterType, this.hasAddOnPageChangeListenerMethod());
            JBlock methodBody = pageChangeHolder.getPageScrolledBody();
            JFieldRef activityRef = holder.getGeneratedClass().staticRef("this");
            JInvocation pageScrollCall = methodBody.invoke((IJExpression)activityRef, methodName);
            for (int i = 0; i < parameters.size(); ++i) {
                if (i == positionParameterPosition) {
                    JVar positionParam = pageChangeHolder.getPageScrolledPositionParam();
                    pageScrollCall.arg((IJExpression)positionParam);
                    continue;
                }
                if (i == positionOffsetParameterPosition) {
                    JVar pageScrolledPositionOffsetParam = pageChangeHolder.getPageScrolledPositionOffsetParam();
                    pageScrollCall.arg((IJExpression)pageScrolledPositionOffsetParam);
                    continue;
                }
                if (i == positionOffsetPixelsParameterPosition) {
                    JVar pageScrolledPositionOffsetPixelsParam = pageChangeHolder.getPageScrolledPositionOffsetPixelsParam();
                    pageScrollCall.arg((IJExpression)pageScrolledPositionOffsetPixelsParam);
                    continue;
                }
                if (i != viewPagerParameterPosition) continue;
                JVar viewParameter = pageChangeHolder.getViewPagerVariable();
                pageScrollCall.arg((IJExpression)viewParameter);
            }
        }
    }
}

