/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.PageScrollStateChanged;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.ValidatorParameterHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.PageChangeHolder;
import org.androidannotations.internal.core.handler.AbstractPageChangeHandler;
import org.androidannotations.rclass.IRClass;

public class PageScrollStateChangedHandler
extends AbstractPageChangeHandler {
    public PageScrollStateChangedHandler(AndroidAnnotationsEnvironment environment) {
        super(PageScrollStateChanged.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        super.validate(element, validation);
        ((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)this.validatorHelper.param.anyOrder().anyOfTypes("android.support.v4.view.ViewPager", "androidx.viewpager.widget.ViewPager")).optional()).primitiveOrWrapper(TypeKind.INT)).optional()).validate((ExecutableElement)element, validation);
    }

    @Override
    public void process(Element element, EComponentWithViewSupportHolder holder) {
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        int stateParameterPosition = -1;
        int viewPagerParameterPosition = -1;
        TypeMirror viewPagerParameterType = null;
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            TypeMirror parameterType = parameter.asType();
            if (parameterType.getKind() == TypeKind.INT || CanonicalNameConstants.INTEGER.equals(parameterType.toString())) {
                stateParameterPosition = i;
                continue;
            }
            if (!this.isViewPagerParameter(parameterType)) continue;
            viewPagerParameterPosition = i;
            viewPagerParameterType = parameterType;
        }
        List<JFieldRef> idsRefs = this.annotationHelper.extractAnnotationFieldRefs(element, IRClass.Res.ID, true);
        for (JFieldRef idRef : idsRefs) {
            PageChangeHolder pageChangeHolder = holder.getPageChangeHolder(idRef, viewPagerParameterType, this.hasAddOnPageChangeListenerMethod());
            JBlock methodBody = pageChangeHolder.getPageScrollStateChangedBody();
            JFieldRef thisRef = holder.getGeneratedClass().staticRef("this");
            JInvocation methodCall = methodBody.invoke((IJExpression)thisRef, methodName);
            for (int i = 0; i < parameters.size(); ++i) {
                if (i == stateParameterPosition) {
                    JVar stateParam = pageChangeHolder.getPageScrollStateChangedStateParam();
                    methodCall.arg((IJExpression)stateParam);
                    continue;
                }
                if (i != viewPagerParameterPosition) continue;
                JVar viewParameter = pageChangeHolder.getViewPagerVariable();
                methodCall.arg((IJExpression)viewParameter);
            }
        }
    }
}

