/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JVar;
import javax.lang.model.element.Element;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.OptionsMenuItem;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.helper.InjectHelper;
import org.androidannotations.holder.HasOptionsMenu;
import org.androidannotations.rclass.IRClass;

public class OptionsMenuItemHandler
extends BaseAnnotationHandler<HasOptionsMenu>
implements MethodInjectionHandler<HasOptionsMenu> {
    private final InjectHelper<HasOptionsMenu> injectHelper;

    public OptionsMenuItemHandler(AndroidAnnotationsEnvironment environment) {
        super(OptionsMenuItem.class, environment);
        this.injectHelper = new InjectHelper<HasOptionsMenu>(this.validatorHelper, this);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.injectHelper.validate(OptionsMenuItem.class, element, validation);
        if (!validation.isValid()) {
            return;
        }
        Element param = this.injectHelper.getParam(element);
        this.validatorHelper.isDeclaredType(param, validation);
        this.validatorHelper.extendsMenuItem(param, validation);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, validation);
        this.validatorHelper.isNotPrivate(element, validation);
    }

    @Override
    public void process(Element element, HasOptionsMenu holder) {
        this.injectHelper.process(element, holder);
    }

    @Override
    public JBlock getInvocationBlock(HasOptionsMenu holder) {
        return holder.getOnCreateOptionsMenuMethodBody();
    }

    @Override
    public void assignValue(JBlock targetBlock, IJAssignmentTarget fieldRef, HasOptionsMenu holder, Element element, Element param) {
        JVar menuParam = holder.getOnCreateOptionsMenuMenuParam();
        JFieldRef idsRef = this.annotationHelper.extractOneAnnotationFieldRef(element, IRClass.Res.ID, true);
        targetBlock.add((IJStatement)fieldRef.assign((IJExpression)menuParam.invoke("findItem").arg((IJExpression)idsRef)));
    }

    @Override
    public void validateEnclosingElement(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEActivityOrEFragment(element, valid);
    }
}

