/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.OptionsMenu;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.HasOptionsMenu;
import org.androidannotations.rclass.IRClass;

public class OptionsMenuHandler
extends BaseAnnotationHandler<HasOptionsMenu> {
    public OptionsMenuHandler(AndroidAnnotationsEnvironment environment) {
        super(OptionsMenu.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.validatorHelper.hasEActivityOrEFragment(element, validation);
        this.validatorHelper.resIdsExist(element, IRClass.Res.MENU, IdValidatorHelper.FallbackStrategy.NEED_RES_ID, validation);
    }

    @Override
    public void process(Element element, HasOptionsMenu holder) {
        JBlock body = holder.getOnCreateOptionsMenuMethodInflateBody();
        JVar menuInflater = holder.getOnCreateOptionsMenuMenuInflaterVar();
        JVar menuParam = holder.getOnCreateOptionsMenuMenuParam();
        List<JFieldRef> fieldRefs = this.annotationHelper.extractAnnotationFieldRefs(element, IRClass.Res.MENU, false);
        for (JFieldRef optionsMenuRefId : fieldRefs) {
            body.invoke((IJExpression)menuInflater, "inflate").arg((IJExpression)optionsMenuRefId).arg((IJExpression)menuParam);
        }
    }
}

