/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.OptionsItem;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.HasOptionsMenu;
import org.androidannotations.rclass.IRClass;

public class OptionsItemHandler
extends BaseAnnotationHandler<HasOptionsMenu> {
    public OptionsItemHandler(AndroidAnnotationsEnvironment environment) {
        super(OptionsItem.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.validatorHelper.enclosingElementHasEActivityOrEFragment(element, validation);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, validation);
        this.validatorHelper.isNotPrivate(element, validation);
        this.validatorHelper.doesntThrowException(element, validation);
        this.validatorHelper.uniqueId(element, validation);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoidOrBoolean(executableElement, validation);
        this.validatorHelper.param.type("android.view.MenuItem").optional().validate(executableElement, validation);
    }

    @Override
    public void process(Element element, HasOptionsMenu holder) {
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        TypeMirror returnType = executableElement.getReturnType();
        boolean returnMethodResult = returnType.getKind() != TypeKind.VOID;
        boolean hasItemParameter = parameters.size() == 1;
        List<JFieldRef> idsRefs = this.annotationHelper.extractAnnotationFieldRefs(element, IRClass.Res.ID, true);
        JBlock block = holder.getOnOptionsItemSelectedMiddleBlock();
        IJExpression ifExpr = holder.getOnOptionsItemSelectedItemId().eq((IJExpression)idsRefs.get(0));
        for (int i = 1; i < idsRefs.size(); ++i) {
            ifExpr = ifExpr.cor(holder.getOnOptionsItemSelectedItemId().eq((IJExpression)idsRefs.get(i)));
        }
        JBlock itemIfBody = block._if(ifExpr)._then();
        JInvocation methodCall = JExpr.invoke((String)methodName);
        if (returnMethodResult) {
            itemIfBody._return((IJExpression)methodCall);
        } else {
            itemIfBody.add((IJStatement)methodCall);
            itemIfBody._return((IJExpression)JExpr.TRUE);
        }
        if (hasItemParameter) {
            methodCall.arg((IJExpression)holder.getOnOptionsItemSelectedItem());
        }
    }
}

