/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JOp;
import com.helger.jcodemodel.JVar;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.OnActivityResult;
import org.androidannotations.handler.AnnotationHandler;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.HasParameterHandlers;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.ValidatorParameterHelper;
import org.androidannotations.holder.HasOnActivityResult;
import org.androidannotations.internal.core.handler.ExtraParameterHandler;

public class OnActivityResultHandler
extends BaseAnnotationHandler<HasOnActivityResult>
implements HasParameterHandlers<HasOnActivityResult> {
    private ExtraHandler extraHandler;

    public OnActivityResultHandler(AndroidAnnotationsEnvironment environment) {
        super(OnActivityResult.class, environment);
        this.extraHandler = new ExtraHandler(environment);
    }

    @Override
    public Iterable<AnnotationHandler> getParameterHandlers() {
        return Collections.singleton(this.extraHandler);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.validatorHelper.enclosingElementHasEActivityOrEFragment(element, validation);
        this.validatorHelper.isNotPrivate(element, validation);
        this.validatorHelper.doesntThrowException(element, validation);
        OnActivityResult onResultAnnotation = element.getAnnotation(OnActivityResult.class);
        this.validatorHelper.annotationValuePositiveAndInAShort(onResultAnnotation.value(), validation);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoid(executableElement, validation);
        ((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)this.validatorHelper.param.anyOrder().type("android.content.Intent")).optional()).primitiveOrWrapper(TypeKind.INT)).optional()).annotatedWith(OnActivityResult.Extra.class)).multiple()).optional()).validate((ExecutableElement)element, validation);
    }

    @Override
    public void process(Element element, HasOnActivityResult holder) throws Exception {
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        int requestCode = executableElement.getAnnotation(OnActivityResult.class).value();
        JBlock onResultBlock = holder.getOnActivityResultCaseBlock(requestCode).blockSimple();
        JFieldRef activityRef = holder.getGeneratedClass().staticRef("this");
        JInvocation onResultInvocation = JExpr.invoke((IJExpression)activityRef, (String)methodName);
        JVar intent = holder.getOnActivityResultDataParam();
        JVar extras = null;
        for (VariableElement variableElement : parameters) {
            TypeMirror parameterType = variableElement.asType();
            if (variableElement.getAnnotation(OnActivityResult.Extra.class) != null) {
                if (extras == null) {
                    extras = onResultBlock.decl((AbstractJType)this.getClasses().BUNDLE, "extras_", (IJExpression)JOp.cond((IJExpression)intent.ne((IJExpression)JExpr._null()).cand(intent.invoke("getExtras").ne((IJExpression)JExpr._null())), (IJExpression)intent.invoke("getExtras"), (IJExpression)JExpr._new((AbstractJClass)this.getClasses().BUNDLE)));
                }
                IJExpression extraParameter = this.extraHandler.getExtraValue(variableElement, extras, onResultBlock, holder);
                onResultInvocation.arg(extraParameter);
                continue;
            }
            if ("android.content.Intent".equals(parameterType.toString())) {
                onResultInvocation.arg((IJExpression)intent);
                continue;
            }
            if (!parameterType.getKind().equals((Object)TypeKind.INT) && !CanonicalNameConstants.INTEGER.equals(parameterType.toString())) continue;
            onResultInvocation.arg((IJExpression)holder.getOnActivityResultResultCodeParam());
        }
        onResultBlock.add((IJStatement)onResultInvocation);
    }

    private static class ExtraHandler
    extends ExtraParameterHandler {
        ExtraHandler(AndroidAnnotationsEnvironment environment) {
            super(OnActivityResult.Extra.class, OnActivityResult.class, environment);
        }

        @Override
        public String getAnnotationValue(VariableElement parameter) {
            return parameter.getAnnotation(OnActivityResult.Extra.class).value();
        }

        public IJExpression getExtraValue(VariableElement parameter, JVar extras, JBlock block, HasOnActivityResult holder) {
            return super.getExtraValue(parameter, extras, block, holder.getOnActivityResultMethod(), holder);
        }
    }
}

