/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JVar;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.Bean;
import org.androidannotations.annotations.EBean;
import org.androidannotations.annotations.NonConfigurationInstance;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.EActivityHolder;
import org.androidannotations.holder.NonConfigurationHolder;

public class NonConfigurationInstanceHandler
extends BaseAnnotationHandler<EActivityHolder> {
    public NonConfigurationInstanceHandler(AndroidAnnotationsEnvironment environment) {
        super(NonConfigurationInstance.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.validatorHelper.enclosingElementHasEActivity(element, validation);
        this.validatorHelper.isNotPrivate(element, validation);
        this.validatorHelper.isNotFinal(element, validation);
        if (element.getAnnotation(Bean.class) != null) {
            this.validatorHelper.typeIsValid(EBean.class, element.asType(), validation);
        }
    }

    @Override
    public void process(Element element, EActivityHolder holder) throws JClassAlreadyExistsException {
        String fieldName = element.getSimpleName().toString();
        AbstractJClass fieldType = this.codeModelHelper.typeMirrorToJClass(element.asType());
        NonConfigurationHolder ncHolder = holder.getNonConfigurationHolder();
        JFieldVar ncHolderField = ncHolder.createField(fieldName, fieldType);
        this.injectInInit(element, holder, fieldName, ncHolderField);
        this.retainInOnRetain(holder, fieldName, ncHolderField);
    }

    private void injectInInit(Element element, EActivityHolder holder, String fieldName, JFieldVar ncHolderField) throws JClassAlreadyExistsException {
        JBlock initIfNonConfigurationNotNullBlock = holder.getInitIfNonConfigurationNotNullBlock();
        JVar initNonConfigurationInstance = holder.getInitNonConfigurationInstance();
        initIfNonConfigurationNotNullBlock.assign((IJAssignmentTarget)JExpr.ref((String)fieldName), (IJExpression)initNonConfigurationInstance.ref((JVar)ncHolderField));
        this.rebindContextIfBean(element, initIfNonConfigurationNotNullBlock, ncHolderField);
    }

    private void retainInOnRetain(EActivityHolder holder, String fieldName, JFieldVar ncHolderField) throws JClassAlreadyExistsException {
        JBlock onRetainNonConfigurationInstanceBindBlock = holder.getOnRetainNonConfigurationInstanceBindBlock();
        JVar onRetainNonConfigurationInstance = holder.getOnRetainNonConfigurationInstance();
        onRetainNonConfigurationInstanceBindBlock.assign((IJAssignmentTarget)onRetainNonConfigurationInstance.ref((JVar)ncHolderField), (IJExpression)JExpr.ref((String)fieldName));
    }

    private void rebindContextIfBean(Element element, JBlock initIfNonConfigurationNotNullBlock, JFieldVar field) {
        boolean hasBeanAnnotation;
        boolean bl = hasBeanAnnotation = element.getAnnotation(Bean.class) != null;
        if (hasBeanAnnotation) {
            TypeMirror elementType = this.annotationHelper.extractAnnotationClassParameter(element, Bean.class.getName());
            if (elementType == null) {
                elementType = element.asType();
            }
            String typeQualifiedName = elementType.toString();
            AbstractJClass fieldGeneratedBeanClass = this.getJClass(typeQualifiedName + ModelConstants.classSuffix());
            Element eBeanTypeElement = this.annotationHelper.getTypeUtils().asElement(elementType);
            EBean eBean = eBeanTypeElement.getAnnotation(EBean.class);
            if (eBean != null && eBean.scope() != EBean.Scope.Singleton) {
                initIfNonConfigurationNotNullBlock.invoke((IJExpression)JExpr.cast((AbstractJType)fieldGeneratedBeanClass, (IJExpression)field), "rebind").arg((IJExpression)JExpr._this());
            }
        }
    }
}

