/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JSwitch;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.annotations.KeyMultiple;
import org.androidannotations.holder.HasKeyEventCallbackMethods;
import org.androidannotations.internal.core.handler.AbstractKeyEventHandler;

public class KeyMultipleHandler
extends AbstractKeyEventHandler {
    public KeyMultipleHandler(AndroidAnnotationsEnvironment environment) {
        super(KeyMultiple.class, environment);
    }

    @Override
    public String[] getParamTypes() {
        return new String[]{"android.view.KeyEvent", Integer.TYPE.getName()};
    }

    @Override
    public JSwitch getSwitchBody(HasKeyEventCallbackMethods holder) {
        return holder.getOnKeyMultipleSwitchBody();
    }

    @Override
    public void passParametersToMethodCall(Element element, HasKeyEventCallbackMethods holder, JInvocation methodCall) {
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() == 1) {
            if (parameters.get(0).asType().toString().equals(Integer.TYPE.getName())) {
                methodCall.arg((IJExpression)holder.getOnKeyMultipleCountParam());
            } else {
                methodCall.arg((IJExpression)holder.getOnKeyMultipleKeyEventParam());
            }
        } else if (parameters.size() == 2) {
            if (parameters.get(0).asType().toString().equals(Integer.TYPE.getName())) {
                methodCall.arg((IJExpression)holder.getOnKeyMultipleCountParam()).arg((IJExpression)holder.getOnKeyMultipleKeyEventParam());
            } else {
                methodCall.arg((IJExpression)holder.getOnKeyMultipleKeyEventParam()).arg((IJExpression)holder.getOnKeyMultipleCountParam());
            }
        }
    }
}

