/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JNarrowedClass;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.ItemSelect;
import org.androidannotations.helper.ValidatorParameterHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.internal.core.handler.AbstractViewListenerHandler;

public class ItemSelectHandler
extends AbstractViewListenerHandler {
    private JMethod onNothingSelectedMethod;

    public ItemSelectHandler(AndroidAnnotationsEnvironment environment) {
        super(ItemSelect.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        super.validate(element, validation);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoid(executableElement, validation);
        ((ValidatorParameterHelper.InOrderParamValidator)((ValidatorParameterHelper.InOrderParamValidator)((ValidatorParameterHelper.InOrderParamValidator)this.validatorHelper.param.inOrder().primitiveOrWrapper(TypeKind.BOOLEAN)).anyType()).optional()).validate(executableElement, validation);
    }

    @Override
    protected void makeCall(JBlock listenerMethodBody, JInvocation call, TypeMirror returnType) {
        listenerMethodBody.add((IJStatement)call);
    }

    @Override
    protected void processParameters(EComponentWithViewSupportHolder holder, JMethod listenerMethod, JInvocation itemSelectedCall, List<? extends VariableElement> parameters) {
        JNarrowedClass narrowAdapterViewClass = this.getClasses().ADAPTER_VIEW.narrow(this.getCodeModel().wildcard());
        JVar onItemClickParentParam = listenerMethod.param((AbstractJType)narrowAdapterViewClass, "parent");
        listenerMethod.param((AbstractJType)this.getClasses().VIEW, "view");
        JVar onItemClickPositionParam = listenerMethod.param((AbstractJType)this.getCodeModel().INT, "position");
        listenerMethod.param((AbstractJType)this.getCodeModel().LONG, "id");
        itemSelectedCall.arg((IJExpression)JExpr.TRUE);
        boolean hasItemParameter = parameters.size() == 2;
        boolean secondParameterIsInt = false;
        String secondParameterQualifiedName = null;
        if (hasItemParameter) {
            VariableElement secondParameter = parameters.get(1);
            TypeMirror secondParameterType = secondParameter.asType();
            secondParameterQualifiedName = secondParameterType.toString();
            boolean bl = secondParameterIsInt = secondParameterType.getKind() == TypeKind.INT;
        }
        if (hasItemParameter) {
            if (secondParameterIsInt) {
                itemSelectedCall.arg((IJExpression)onItemClickPositionParam);
            } else {
                itemSelectedCall.arg((IJExpression)JExpr.cast((AbstractJType)this.getJClass(secondParameterQualifiedName), (IJExpression)JExpr.invoke((IJExpression)onItemClickParentParam, (String)"getAdapter").invoke("getItem").arg((IJExpression)onItemClickPositionParam)));
            }
        }
        this.onNothingSelectedMethod.param((AbstractJType)narrowAdapterViewClass, "parent");
        JFieldRef activityRef = holder.getGeneratedClass().staticRef("this");
        JInvocation nothingSelectedCall = JExpr.invoke((IJExpression)activityRef, (String)this.getMethodName());
        this.onNothingSelectedMethod.body().add((IJStatement)nothingSelectedCall);
        nothingSelectedCall.arg((IJExpression)JExpr.FALSE);
        if (hasItemParameter) {
            if (secondParameterIsInt) {
                nothingSelectedCall.arg((IJExpression)JExpr.lit((int)-1));
            } else {
                nothingSelectedCall.arg((IJExpression)JExpr._null());
            }
        }
    }

    @Override
    protected JMethod createListenerMethod(JDefinedClass listenerAnonymousClass) {
        this.onNothingSelectedMethod = listenerAnonymousClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onNothingSelected");
        this.onNothingSelectedMethod.annotate(Override.class);
        return listenerAnonymousClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onItemSelected");
    }

    @Override
    protected String getSetterName() {
        return "setOnItemSelectedListener";
    }

    @Override
    protected AbstractJClass getListenerClass(EComponentWithViewSupportHolder holder) {
        return this.getClasses().ON_ITEM_SELECTED_LISTENER;
    }

    @Override
    protected AbstractJClass getListenerTargetClass(EComponentWithViewSupportHolder holder) {
        return this.getClasses().ADAPTER_VIEW.narrow(this.getCodeModel().wildcard());
    }
}

