/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JNarrowedClass;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.ItemLongClick;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.internal.core.handler.AbstractViewListenerHandler;

public class ItemLongClickHandler
extends AbstractViewListenerHandler {
    public ItemLongClickHandler(AndroidAnnotationsEnvironment environment) {
        super(ItemLongClick.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        super.validate(element, validation);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoidOrBoolean(executableElement, validation);
        this.validatorHelper.param.anyType().optional().validate(executableElement, validation);
    }

    @Override
    protected void makeCall(JBlock listenerMethodBody, JInvocation call, TypeMirror returnType) {
        boolean returnMethodResult;
        boolean bl = returnMethodResult = returnType.getKind() != TypeKind.VOID;
        if (returnMethodResult) {
            listenerMethodBody._return((IJExpression)call);
        } else {
            listenerMethodBody.add((IJStatement)call);
            listenerMethodBody._return((IJExpression)JExpr.TRUE);
        }
    }

    @Override
    protected void processParameters(EComponentWithViewSupportHolder holder, JMethod listenerMethod, JInvocation call, List<? extends VariableElement> parameters) {
        boolean hasItemParameter = parameters.size() == 1;
        JNarrowedClass narrowAdapterViewClass = this.getClasses().ADAPTER_VIEW.narrow(this.getCodeModel().wildcard());
        JVar onItemClickParentParam = listenerMethod.param((AbstractJType)narrowAdapterViewClass, "parent");
        listenerMethod.param((AbstractJType)this.getClasses().VIEW, "view");
        JVar onItemClickPositionParam = listenerMethod.param((AbstractJType)this.getCodeModel().INT, "position");
        listenerMethod.param((AbstractJType)this.getCodeModel().LONG, "id");
        if (hasItemParameter) {
            VariableElement parameter = parameters.get(0);
            TypeMirror parameterType = parameter.asType();
            if (parameterType.getKind() == TypeKind.INT) {
                call.arg((IJExpression)onItemClickPositionParam);
            } else {
                AbstractJClass parameterClass = this.codeModelHelper.typeMirrorToJClass(parameterType);
                call.arg((IJExpression)JExpr.cast((AbstractJType)parameterClass, (IJExpression)JExpr.invoke((IJExpression)onItemClickParentParam, (String)"getAdapter").invoke("getItem").arg((IJExpression)onItemClickPositionParam)));
                if (parameterClass.isParameterized()) {
                    this.codeModelHelper.addSuppressWarnings((IJAnnotatable)listenerMethod, "unchecked");
                }
            }
        }
    }

    @Override
    protected JMethod createListenerMethod(JDefinedClass listenerAnonymousClass) {
        return listenerAnonymousClass.method(1, (AbstractJType)this.getCodeModel().BOOLEAN, "onItemLongClick");
    }

    @Override
    protected String getSetterName() {
        return "setOnItemLongClickListener";
    }

    @Override
    protected AbstractJClass getListenerClass(EComponentWithViewSupportHolder holder) {
        return this.getClasses().ON_ITEM_LONG_CLICK_LISTENER;
    }

    @Override
    protected AbstractJClass getListenerTargetClass(EComponentWithViewSupportHolder holder) {
        return this.getClasses().ADAPTER_VIEW.narrow(this.getCodeModel().wildcard());
    }
}

