/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.InstanceState;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.BundleHelper;
import org.androidannotations.holder.HasInstanceState;

public class InstanceStateHandler
extends BaseAnnotationHandler<HasInstanceState> {
    public InstanceStateHandler(AndroidAnnotationsEnvironment environment) {
        super(InstanceState.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.validatorHelper.enclosingElementHasEActivityOrEFragmentOrEViewOrEViewGroup(element, validation);
        this.validatorHelper.isNotPrivate(element, validation);
        this.validatorHelper.canBePutInABundle(element, validation);
        this.validatorHelper.isNotFinal(element, validation);
    }

    @Override
    public void process(Element element, HasInstanceState holder) {
        AbstractJClass elementClass = this.codeModelHelper.typeMirrorToJClass(element.asType());
        String fieldName = element.getSimpleName().toString();
        JBlock saveStateBody = holder.getSaveStateMethodBody();
        JVar saveStateBundleParam = holder.getSaveStateBundleParam();
        JMethod restoreStateMethod = holder.getRestoreStateMethod();
        JBlock restoreStateBody = holder.getRestoreStateMethodBody();
        JVar restoreStateBundleParam = holder.getRestoreStateBundleParam();
        TypeMirror type = this.codeModelHelper.getActualType(element, holder);
        BundleHelper bundleHelper = new BundleHelper(this.getEnvironment(), type);
        JFieldRef ref = JExpr.ref((String)fieldName);
        saveStateBody.add(bundleHelper.getExpressionToSaveFromField((IJExpression)saveStateBundleParam, (IJExpression)JExpr.lit((String)fieldName), (IJExpression)ref));
        IJExpression restoreMethodCall = bundleHelper.getExpressionToRestoreFromBundle(elementClass, (IJExpression)restoreStateBundleParam, (IJExpression)JExpr.lit((String)fieldName), restoreStateMethod);
        restoreStateBody.assign((IJAssignmentTarget)ref, restoreMethodCall);
    }
}

