/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JConditional;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JMethod;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.IgnoreWhen;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.holder.EFragmentHolder;

public class IgnoreWhenHandler
extends BaseAnnotationHandler<EFragmentHolder> {
    public IgnoreWhenHandler(AndroidAnnotationsEnvironment environment) {
        super(IgnoreWhen.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation valid) {
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.isNotFinal(element, valid);
        this.validatorHelper.returnTypeIsVoid((ExecutableElement)element, valid);
        this.validatorHelper.enclosingElementHasEFragment(element, valid);
    }

    @Override
    public void process(Element element, EFragmentHolder holder) throws Exception {
        ExecutableElement executableElement = (ExecutableElement)element;
        JMethod delegatingMethod = this.codeModelHelper.overrideAnnotatedMethod(executableElement, holder);
        JBlock previousMethodBody = this.codeModelHelper.removeBody(delegatingMethod);
        IgnoreWhen ignoreWhen = element.getAnnotation(IgnoreWhen.class);
        JBlock methodBody = delegatingMethod.body();
        JConditional conditional = null;
        switch (ignoreWhen.value()) {
            case VIEW_DESTROYED: {
                conditional = methodBody._if(holder.getViewDestroyedField().not());
                break;
            }
            case DETACHED: {
                conditional = methodBody._if(JExpr.invoke((IJExpression)holder.getGeneratedClass().staticRef("this"), (String)"getActivity").ne((IJExpression)JExpr._null()));
            }
        }
        conditional._then().add((IJStatement)previousMethodBody);
    }
}

