/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAnonymousClass;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCast;
import com.helger.jcodemodel.JCatchBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JTryBlock;
import com.helger.jcodemodel.JVar;
import javax.lang.model.element.Element;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.HttpsClient;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.InjectHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.internal.process.ProcessHolder;
import org.androidannotations.rclass.IRClass;
import org.androidannotations.rclass.IRInnerClass;

public class HttpsClientHandler
extends BaseAnnotationHandler<EComponentHolder>
implements MethodInjectionHandler<EComponentHolder> {
    private final InjectHelper<EComponentHolder> injectHelper;

    public HttpsClientHandler(AndroidAnnotationsEnvironment environment) {
        super(HttpsClient.class, environment);
        this.injectHelper = new InjectHelper<EComponentHolder>(this.validatorHelper, this);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.injectHelper.validate(HttpsClient.class, element, validation);
        if (!validation.isValid()) {
            return;
        }
        this.validatorHelper.annotationParameterIsOptionalValidResId(element, IRClass.Res.RAW, "keyStore", validation);
        this.validatorHelper.annotationParameterIsOptionalValidResId(element, IRClass.Res.RAW, "trustStore", validation);
        this.validatorHelper.isNotPrivate(element, validation);
    }

    @Override
    public void process(Element element, EComponentHolder holder) throws Exception {
        this.injectHelper.process(element, holder);
    }

    @Override
    public JBlock getInvocationBlock(EComponentHolder holder) {
        return holder.getInitBodyInjectionBlock();
    }

    @Override
    public void assignValue(JBlock targetBlock, IJAssignmentTarget fieldRef, EComponentHolder holder, Element element, Element param) {
        IRInnerClass rInnerClass = this.getEnvironment().getRClass().get(IRClass.Res.RAW);
        HttpsClient annotation = element.getAnnotation(HttpsClient.class);
        JFieldRef trustStoreRawIdRef = this.annotationHelper.extractOneAnnotationFieldRef(element, this.getTarget(), rInnerClass, false, "trustStore", "trustStoreResName");
        JFieldRef keyStoreRawIdRef = this.annotationHelper.extractOneAnnotationFieldRef(element, this.getTarget(), rInnerClass, false, "keyStore", "keyStoreResName");
        String trustStorePwd = annotation.trustStorePwd();
        String keyStorePwd = annotation.keyStorePwd();
        boolean allowAllHostnames = annotation.allowAllHostnames();
        boolean useCustomTrustStore = trustStoreRawIdRef != null;
        boolean useCustomKeyStore = keyStoreRawIdRef != null;
        ProcessHolder.Classes classes = this.getClasses();
        JAnonymousClass jAnonClass = this.getCodeModel().anonymousClass(classes.DEFAULT_HTTP_CLIENT);
        JMethod method = jAnonClass.method(2, (AbstractJType)classes.CLIENT_CONNECTION_MANAGER, "createClientConnectionManager");
        method.annotate(Override.class);
        JTryBlock jTryBlock = method.body()._try();
        JVar jVarTrusted = null;
        JVar jVarKeystore = null;
        if (useCustomKeyStore) {
            jVarKeystore = jTryBlock.body().decl((AbstractJType)classes.KEY_STORE, "keystore");
            jVarKeystore.init((IJExpression)classes.KEY_STORE.staticInvoke("getInstance").arg("BKS"));
        }
        if (useCustomTrustStore || useCustomKeyStore) {
            jVarTrusted = jTryBlock.body().decl((AbstractJType)classes.KEY_STORE, "trusted");
            jVarTrusted.init((IJExpression)classes.KEY_STORE.staticInvoke("getInstance").arg("BKS"));
        }
        JVar jVarRes = null;
        JVar jVarTrstFile = null;
        JVar jVarKeyFile = null;
        if (useCustomKeyStore || useCustomTrustStore) {
            jVarRes = jTryBlock.body().decl((AbstractJType)classes.RESOURCES, "res", (IJExpression)JExpr.invoke((String)"getResources"));
        }
        if (useCustomKeyStore) {
            JInvocation jInvRawKey = jVarRes.invoke("openRawResource").arg((IJExpression)keyStoreRawIdRef);
            jVarKeyFile = jTryBlock.body().decl((AbstractJType)classes.INPUT_STREAM, "inKeystore", (IJExpression)jInvRawKey);
        }
        if (useCustomTrustStore) {
            JInvocation jInvRawTrust = jVarRes.invoke("openRawResource").arg((IJExpression)trustStoreRawIdRef);
            jVarTrstFile = jTryBlock.body().decl((AbstractJType)classes.INPUT_STREAM, "inTrustStore", (IJExpression)jInvRawTrust);
        } else if (useCustomKeyStore) {
            jVarTrstFile = jTryBlock.body().decl((AbstractJType)classes.INPUT_STREAM, "inTrustStore", (IJExpression)JExpr._new((AbstractJClass)classes.FILE_INPUT_STREAM).arg("/system/etc/security/cacerts.bks"));
        }
        if (useCustomKeyStore || useCustomTrustStore) {
            JTryBlock jTryLoad = jTryBlock.body()._try();
            if (useCustomKeyStore) {
                jTryLoad.body().add((IJStatement)JExpr.invoke((IJExpression)jVarKeystore, (String)"load").arg((IJExpression)jVarKeyFile).arg((IJExpression)JExpr.invoke((IJExpression)JExpr.lit((String)keyStorePwd), (String)"toCharArray")));
            }
            jTryLoad.body().add((IJStatement)JExpr.invoke((IJExpression)jVarTrusted, (String)"load").arg((IJExpression)jVarTrstFile).arg((IJExpression)JExpr.invoke((IJExpression)JExpr.lit((String)trustStorePwd), (String)"toCharArray")));
            JBlock jFinally = jTryLoad._finally();
            if (useCustomKeyStore) {
                jFinally.add((IJStatement)JExpr.invoke((IJExpression)jVarKeyFile, (String)"close"));
            }
            jFinally.add((IJStatement)JExpr.invoke((IJExpression)jVarTrstFile, (String)"close"));
        }
        if (null == jVarKeystore && null == jVarTrusted) {
            JVar jVarCcm = jTryBlock.body().decl((AbstractJType)classes.CLIENT_CONNECTION_MANAGER, "ccm");
            jVarCcm.init((IJExpression)JExpr._super().invoke("createClientConnectionManager"));
            if (allowAllHostnames) {
                JCast jCast = JExpr.cast((AbstractJType)classes.SSL_SOCKET_FACTORY, (IJExpression)jVarCcm.invoke("getSchemeRegistry").invoke("getScheme").arg("https").invoke("getSocketFactory"));
                jTryBlock.body().add((IJStatement)jCast.invoke("setHostnameVerifier").arg((IJExpression)classes.SSL_SOCKET_FACTORY.staticRef("ALLOW_ALL_HOSTNAME_VERIFIER")));
            }
            jTryBlock.body()._return((IJExpression)jVarCcm);
        } else {
            JVar jVarSslFact = jTryBlock.body().decl((AbstractJType)classes.SSL_SOCKET_FACTORY, "newSslSocketFactory");
            jVarSslFact.init((IJExpression)JExpr._new((AbstractJClass)classes.SSL_SOCKET_FACTORY).arg((IJExpression)(null == jVarKeystore ? JExpr._null() : jVarKeystore)).arg(keyStorePwd).arg((IJExpression)jVarTrusted));
            if (allowAllHostnames) {
                jTryBlock.body().add((IJStatement)JExpr.invoke((IJExpression)jVarSslFact, (String)"setHostnameVerifier").arg((IJExpression)classes.SSL_SOCKET_FACTORY.staticRef("ALLOW_ALL_HOSTNAME_VERIFIER")));
            }
            JVar jVarSchemeReg = jTryBlock.body().decl((AbstractJType)classes.SCHEME_REGISTRY, "registry");
            jVarSchemeReg.init((IJExpression)JExpr._new((AbstractJClass)classes.SCHEME_REGISTRY));
            jTryBlock.body().add((IJStatement)JExpr.invoke((IJExpression)jVarSchemeReg, (String)"register").arg((IJExpression)JExpr._new((AbstractJClass)classes.SCHEME).arg("https").arg((IJExpression)jVarSslFact).arg((IJExpression)JExpr.lit((int)443))));
            jTryBlock.body().add((IJStatement)JExpr.invoke((IJExpression)jVarSchemeReg, (String)"register").arg((IJExpression)JExpr._new((AbstractJClass)classes.SCHEME).arg("http").arg((IJExpression)classes.PLAIN_SOCKET_FACTORY.staticInvoke("getSocketFactory")).arg((IJExpression)JExpr.lit((int)80))));
            JVar jVarCcm = jTryBlock.body().decl((AbstractJType)classes.CLIENT_CONNECTION_MANAGER, "ccm");
            jVarCcm.init((IJExpression)JExpr._new((AbstractJClass)classes.SINGLE_CLIENT_CONN_MANAGER).arg((IJExpression)JExpr.invoke((String)"getParams")).arg((IJExpression)jVarSchemeReg));
            jTryBlock.body()._return((IJExpression)jVarCcm);
        }
        JCatchBlock jCatchBlock = jTryBlock._catch(classes.EXCEPTION);
        JVar jVarExceptionParam = jCatchBlock.param("e");
        jCatchBlock.body().add((IJStatement)jVarExceptionParam.invoke("printStackTrace"));
        jCatchBlock.body()._return((IJExpression)JExpr._super().invoke("createClientConnectionManager"));
        targetBlock.add((IJStatement)fieldRef.assign((IJExpression)JExpr._new((AbstractJClass)jAnonClass)));
    }

    @Override
    public void validateEnclosingElement(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, valid);
    }
}

