/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JMethod;
import javax.lang.model.element.Element;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.FragmentById;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.internal.core.handler.AbstractFragmentByHandler;
import org.androidannotations.rclass.IRClass;

public class FragmentByIdHandler
extends AbstractFragmentByHandler {
    public FragmentByIdHandler(AndroidAnnotationsEnvironment environment) {
        super(FragmentById.class, environment, "findFragmentById");
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        super.validate(element, validation);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, validation);
    }

    @Override
    protected JMethod getFindFragmentMethod(boolean isNativeFragment, EComponentWithViewSupportHolder holder) {
        return isNativeFragment ? holder.getFindNativeFragmentById() : holder.getFindSupportFragmentById();
    }

    @Override
    protected IJExpression getFragmentId(Element element, String fieldName) {
        return this.annotationHelper.extractOneAnnotationFieldRef(element, IRClass.Res.ID, true);
    }
}

