/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JConditional;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.FragmentArg;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.BundleHelper;
import org.androidannotations.helper.CaseHelper;
import org.androidannotations.helper.InjectHelper;
import org.androidannotations.holder.EFragmentHolder;

public class FragmentArgHandler
extends BaseAnnotationHandler<EFragmentHolder>
implements MethodInjectionHandler<EFragmentHolder>,
MethodInjectionHandler.AfterAllParametersInjectedHandler<EFragmentHolder> {
    private final InjectHelper<EFragmentHolder> injectHelper;

    public FragmentArgHandler(AndroidAnnotationsEnvironment environment) {
        super(FragmentArg.class, environment);
        this.injectHelper = new InjectHelper<EFragmentHolder>(this.validatorHelper, this);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.injectHelper.validate(FragmentArg.class, element, validation);
        if (!validation.isValid()) {
            return;
        }
        this.validatorHelper.isNotPrivate(element, validation);
        Element param = this.injectHelper.getParam(element);
        this.validatorHelper.canBePutInABundle(param, validation);
    }

    @Override
    public void process(Element element, EFragmentHolder holder) {
        this.injectHelper.process(element, holder);
    }

    @Override
    public JBlock getInvocationBlock(EFragmentHolder holder) {
        return holder.getInjectArgsBlock();
    }

    @Override
    public void assignValue(JBlock targetBlock, IJAssignmentTarget fieldRef, EFragmentHolder holder, Element element, Element param) {
        String fieldName = element.getSimpleName().toString();
        String argKey = this.extractArgKey(element, fieldName);
        if (element.getKind() != ElementKind.PARAMETER) {
            this.createBuilderInjectionMethod(holder, element, new ArgHelper(param, argKey));
        }
        TypeMirror actualType = this.codeModelHelper.getActualTypeOfEnclosingElementOfInjectedElement(holder, param);
        AbstractJClass elementClass = this.codeModelHelper.typeMirrorToJClass(actualType);
        BundleHelper bundleHelper = new BundleHelper(this.getEnvironment(), actualType);
        JVar bundle = holder.getInjectBundleArgs();
        JMethod injectExtrasMethod = holder.getInjectArgsMethod();
        JFieldVar extraKeyStaticField = this.getOrCreateStaticArgField(holder, argKey, fieldName);
        IJExpression restoreMethodCall = bundleHelper.getExpressionToRestoreFromBundle(elementClass, (IJExpression)bundle, (IJExpression)extraKeyStaticField, injectExtrasMethod);
        JConditional conditional = targetBlock._if((IJExpression)JExpr.invoke((IJExpression)bundle, (String)"containsKey").arg((IJExpression)extraKeyStaticField));
        conditional._then().add((IJStatement)fieldRef.assign(restoreMethodCall));
    }

    @Override
    public void validateEnclosingElement(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEFragment(element, valid);
    }

    @Override
    public void afterAllParametersInjected(EFragmentHolder holder, ExecutableElement method, List<InjectHelper.ParamHelper> parameterList) {
        ArrayList<ArgHelper> argHelpers = new ArrayList<ArgHelper>();
        for (InjectHelper.ParamHelper paramHelper : parameterList) {
            Element param = paramHelper.getParameterElement();
            String fieldName = param.getSimpleName().toString();
            String argKey = this.extractArgKey(param, fieldName);
            argHelpers.add(new ArgHelper(param, argKey));
        }
        this.createBuilderInjectMethod(holder, method, argHelpers);
    }

    private String extractArgKey(Element element, String fieldName) {
        FragmentArg annotation = element.getAnnotation(FragmentArg.class);
        String argKey = annotation.value();
        if (argKey.isEmpty()) {
            argKey = fieldName;
        }
        return argKey;
    }

    private JFieldVar getOrCreateStaticArgField(EFragmentHolder holder, String argKey, String fieldName) {
        String staticFieldName = CaseHelper.camelCaseToUpperSnakeCase(null, fieldName, "Arg");
        JFieldVar staticExtraField = (JFieldVar)holder.getGeneratedClass().fields().get(staticFieldName);
        if (staticExtraField == null) {
            staticExtraField = holder.getGeneratedClass().field(25, (AbstractJType)this.getClasses().STRING, staticFieldName, (IJExpression)JExpr.lit((String)argKey));
        }
        return staticExtraField;
    }

    private void createBuilderInjectionMethod(EFragmentHolder holder, Element element, ArgHelper argHelper) {
        this.createBuilderInjectMethod(holder, element, Collections.singletonList(argHelper));
    }

    public void createBuilderInjectMethod(EFragmentHolder holder, Element element, List<ArgHelper> argHelpers) {
        JDefinedClass builderClass = holder.getBuilderClass();
        JFieldRef builderArgsField = holder.getBuilderArgsField();
        JMethod builderMethod = builderClass.method(1, (AbstractJType)holder.narrow((AbstractJClass)builderClass), element.getSimpleName().toString());
        String docComment = this.getProcessingEnvironment().getElementUtils().getDocComment(element);
        this.codeModelHelper.addTrimmedDocComment(builderMethod, docComment);
        for (ArgHelper argHelper : argHelpers) {
            String fieldName = argHelper.param.getSimpleName().toString();
            TypeMirror actualType = this.codeModelHelper.getActualTypeOfEnclosingElementOfInjectedElement(holder, argHelper.param);
            BundleHelper bundleHelper = new BundleHelper(this.getEnvironment(), actualType);
            JFieldVar argKeyStaticField = this.getOrCreateStaticArgField(holder, argHelper.argKey, fieldName);
            AbstractJClass paramClass = this.codeModelHelper.typeMirrorToJClass(actualType);
            JVar arg = builderMethod.param((AbstractJType)paramClass, fieldName);
            builderMethod.body().add(bundleHelper.getExpressionToSaveFromField((IJExpression)builderArgsField, (IJExpression)argKeyStaticField, (IJExpression)arg));
            builderMethod.javadoc().addParam(fieldName).append((Object)"value for this Fragment argument");
        }
        builderMethod.javadoc().addReturn().append((Object)"the FragmentBuilder to chain calls");
        builderMethod.body()._return((IJExpression)JExpr._this());
    }

    private static class ArgHelper {
        private final Element param;
        private final String argKey;

        ArgHelper(Element param, String argKey) {
            this.param = param;
            this.argKey = argKey;
        }
    }
}

