/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.FocusChange;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.ValidatorParameterHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.internal.core.handler.AbstractViewListenerHandler;

public class FocusChangeHandler
extends AbstractViewListenerHandler {
    public FocusChangeHandler(AndroidAnnotationsEnvironment environment) {
        super(FocusChange.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        super.validate(element, validation);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoid(executableElement, validation);
        ((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)this.validatorHelper.param.anyOrder().extendsType("android.view.View")).optional()).primitiveOrWrapper(TypeKind.BOOLEAN)).optional()).validate(executableElement, validation);
    }

    @Override
    protected void makeCall(JBlock listenerMethodBody, JInvocation call, TypeMirror returnType) {
        listenerMethodBody.add((IJStatement)call);
    }

    @Override
    protected void processParameters(EComponentWithViewSupportHolder holder, JMethod listenerMethod, JInvocation call, List<? extends VariableElement> parameters) {
        JVar viewParam = listenerMethod.param((AbstractJType)this.getClasses().VIEW, "view");
        JVar hasFocusParam = listenerMethod.param((AbstractJType)this.getCodeModel().BOOLEAN, "hasFocus");
        for (VariableElement variableElement : parameters) {
            String parameterType = variableElement.asType().toString();
            if (this.isTypeOrSubclass("android.view.View", variableElement)) {
                call.arg(this.castArgumentIfNecessary(holder, "android.view.View", viewParam, variableElement));
                continue;
            }
            if (!parameterType.equals(CanonicalNameConstants.BOOLEAN) && variableElement.asType().getKind() != TypeKind.BOOLEAN) continue;
            call.arg((IJExpression)hasFocusParam);
        }
    }

    @Override
    protected JMethod createListenerMethod(JDefinedClass listenerAnonymousClass) {
        return listenerAnonymousClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onFocusChange");
    }

    @Override
    protected String getSetterName() {
        return "setOnFocusChangeListener";
    }

    @Override
    protected AbstractJClass getListenerClass(EComponentWithViewSupportHolder holder) {
        return this.getClasses().VIEW_ON_FOCUS_CHANGE_LISTENER;
    }
}

