/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.lang.annotation.Annotation;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.BundleHelper;
import org.androidannotations.helper.CaseHelper;
import org.androidannotations.holder.GeneratedClassHolder;

public abstract class ExtraParameterHandler
extends BaseAnnotationHandler<GeneratedClassHolder> {
    private Class<? extends Annotation> methodAnnotationClass;

    public ExtraParameterHandler(Class<? extends Annotation> targetClass, Class<? extends Annotation> methodAnnotationClass, AndroidAnnotationsEnvironment environment) {
        super(targetClass, environment);
        this.methodAnnotationClass = methodAnnotationClass;
    }

    @Override
    protected void validate(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasAnnotation(this.methodAnnotationClass, element, valid);
        this.validatorHelper.canBePutInABundle(element, valid);
    }

    @Override
    public void process(Element element, GeneratedClassHolder holder) throws Exception {
    }

    public IJExpression getExtraValue(VariableElement parameter, JVar extras, JBlock block, JMethod annotatedMethod, GeneratedClassHolder holder) {
        return this.getExtraValue(parameter, extras, block, annotatedMethod, holder.getGeneratedClass());
    }

    public IJExpression getExtraValue(VariableElement parameter, JVar extras, JBlock block, JMethod annotatedMethod, JDefinedClass generatedClass) {
        String parameterName = parameter.getSimpleName().toString();
        AbstractJClass parameterClass = this.codeModelHelper.typeMirrorToJClass(parameter.asType());
        String extraKey = this.getAnnotationValue(parameter);
        if (extraKey == null || extraKey.isEmpty()) {
            extraKey = parameterName;
        }
        BundleHelper bundleHelper = new BundleHelper(this.getEnvironment(), parameter.asType());
        IJExpression restoreMethodCall = bundleHelper.getExpressionToRestoreFromBundle(parameterClass, (IJExpression)extras, (IJExpression)this.getStaticExtraField(generatedClass, extraKey), annotatedMethod);
        return block.decl((AbstractJType)parameterClass, parameterName, restoreMethodCall);
    }

    private JFieldVar getStaticExtraField(JDefinedClass generatedClass, String extraName) {
        String staticFieldName = CaseHelper.camelCaseToUpperSnakeCase(null, extraName, "Extra");
        JFieldVar staticExtraField = (JFieldVar)generatedClass.fields().get(staticFieldName);
        if (staticExtraField == null) {
            staticExtraField = generatedClass.field(25, (AbstractJType)this.getClasses().STRING, staticFieldName, (IJExpression)JExpr.lit((String)extraName));
        }
        return staticExtraField;
    }

    public abstract String getAnnotationValue(VariableElement var1);
}

