/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.Extra;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.BundleHelper;
import org.androidannotations.helper.CaseHelper;
import org.androidannotations.helper.InjectHelper;
import org.androidannotations.holder.EActivityHolder;
import org.androidannotations.internal.core.helper.IntentBuilder;

public class ExtraHandler
extends BaseAnnotationHandler<EActivityHolder>
implements MethodInjectionHandler<EActivityHolder>,
MethodInjectionHandler.AfterAllParametersInjectedHandler<EActivityHolder> {
    private final InjectHelper<EActivityHolder> injectHelper;

    public ExtraHandler(AndroidAnnotationsEnvironment environment) {
        super(Extra.class, environment);
        this.injectHelper = new InjectHelper<EActivityHolder>(this.validatorHelper, this);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.injectHelper.validate(Extra.class, element, validation);
        if (!validation.isValid()) {
            return;
        }
        this.validatorHelper.isNotPrivate(element, validation);
        Element param = this.injectHelper.getParam(element);
        this.validatorHelper.canBePutInABundle(param, validation);
    }

    @Override
    public void process(Element element, EActivityHolder holder) {
        this.injectHelper.process(element, holder);
    }

    @Override
    public JBlock getInvocationBlock(EActivityHolder holder) {
        return holder.getInjectExtrasBlock();
    }

    @Override
    public void assignValue(JBlock targetBlock, IJAssignmentTarget fieldRef, EActivityHolder holder, Element element, Element param) {
        String fieldName = element.getSimpleName().toString();
        String extraKey = this.extractExtraKey(element, fieldName);
        TypeMirror actualType = this.codeModelHelper.getActualTypeOfEnclosingElementOfInjectedElement(holder, param);
        BundleHelper bundleHelper = new BundleHelper(this.getEnvironment(), actualType);
        JFieldVar extraKeyStaticField = this.getOrCreateStaticExtraField(holder, extraKey, fieldName);
        if (element.getKind() != ElementKind.PARAMETER) {
            holder.getIntentBuilder().getPutExtraMethod(element, new IntentBuilder.IntentExtra(param.asType(), fieldName, extraKeyStaticField));
        }
        AbstractJClass elementClass = this.codeModelHelper.typeMirrorToJClass(param.asType());
        JMethod injectExtrasMethod = holder.getInjectExtrasMethod();
        JVar extras = holder.getInjectExtras();
        IJExpression restoreMethodCall = bundleHelper.getExpressionToRestoreFromBundle(elementClass, (IJExpression)extras, (IJExpression)extraKeyStaticField, injectExtrasMethod);
        JBlock ifContainsKey = targetBlock._if((IJExpression)JExpr.invoke((IJExpression)extras, (String)"containsKey").arg((IJExpression)extraKeyStaticField))._then();
        ifContainsKey.assign(fieldRef, restoreMethodCall);
    }

    @Override
    public void validateEnclosingElement(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEActivity(element, valid);
    }

    @Override
    public void afterAllParametersInjected(EActivityHolder holder, ExecutableElement method, List<InjectHelper.ParamHelper> parameterList) {
        ArrayList<IntentBuilder.IntentExtra> params = new ArrayList<IntentBuilder.IntentExtra>();
        for (InjectHelper.ParamHelper paramHelper : parameterList) {
            Element param = paramHelper.getParameterElement();
            String fieldName = param.getSimpleName().toString();
            String extraKey = this.extractExtraKey(param, fieldName);
            JFieldVar extraKeyStaticField = this.getOrCreateStaticExtraField(holder, extraKey, fieldName);
            params.add(new IntentBuilder.IntentExtra(param.asType(), fieldName, extraKeyStaticField));
        }
        holder.getIntentBuilder().getPutExtraMethod((Element)method, params);
    }

    private String extractExtraKey(Element element, String fieldName) {
        Extra annotation = element.getAnnotation(Extra.class);
        String extraKey = annotation.value();
        if (extraKey.isEmpty()) {
            extraKey = fieldName;
        }
        return extraKey;
    }

    private JFieldVar getOrCreateStaticExtraField(EActivityHolder holder, String extraKey, String fieldName) {
        String staticFieldName = CaseHelper.camelCaseToUpperSnakeCase(null, fieldName, "Extra");
        JFieldVar staticExtraField = (JFieldVar)holder.getGeneratedClass().fields().get(staticFieldName);
        if (staticExtraField == null) {
            staticExtraField = holder.getGeneratedClass().field(25, (AbstractJType)this.getClasses().STRING, staticFieldName, (IJExpression)JExpr.lit((String)extraKey));
        }
        return staticExtraField;
    }
}

