/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.DataBound;
import org.androidannotations.annotations.EViewGroup;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EViewGroupHolder;
import org.androidannotations.internal.core.handler.CoreBaseGeneratingAnnotationHandler;
import org.androidannotations.rclass.IRClass;

public class EViewGroupHandler
extends CoreBaseGeneratingAnnotationHandler<EViewGroupHolder> {
    public EViewGroupHandler(AndroidAnnotationsEnvironment environment) {
        super(EViewGroup.class, environment);
    }

    @Override
    public EViewGroupHolder createGeneratedClassHolder(AndroidAnnotationsEnvironment environment, TypeElement annotatedElement) throws Exception {
        return new EViewGroupHolder(environment, annotatedElement);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        super.validate(element, validation);
        this.validatorHelper.extendsViewGroup(element, validation);
        this.validatorHelper.resIdsExist(element, IRClass.Res.LAYOUT, IdValidatorHelper.FallbackStrategy.ALLOW_NO_RES_ID, validation);
        this.coreValidatorHelper.checkDataBoundAnnotation(element, validation);
    }

    @Override
    public void process(Element element, EViewGroupHolder holder) {
        JFieldRef contentViewId = this.annotationHelper.extractOneAnnotationFieldRef(element, IRClass.Res.LAYOUT, false);
        if (contentViewId == null) {
            return;
        }
        if (element.getAnnotation(DataBound.class) != null) {
            holder.getSetContentViewBlock().assign((IJAssignmentTarget)holder.getDataBindingField(), holder.getDataBindingInflationExpression((IJExpression)contentViewId, (IJExpression)JExpr._this(), true));
        } else {
            holder.getSetContentViewBlock().invoke("inflate").arg(holder.getContextRef()).arg((IJExpression)contentViewId).arg((IJExpression)JExpr._this());
        }
    }
}

