/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JVar;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.DataBound;
import org.androidannotations.annotations.EFragment;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EFragmentHolder;
import org.androidannotations.internal.core.handler.CoreBaseGeneratingAnnotationHandler;
import org.androidannotations.rclass.IRClass;

public class EFragmentHandler
extends CoreBaseGeneratingAnnotationHandler<EFragmentHolder> {
    public EFragmentHandler(AndroidAnnotationsEnvironment environment) {
        super(EFragment.class, environment);
    }

    @Override
    public EFragmentHolder createGeneratedClassHolder(AndroidAnnotationsEnvironment environment, TypeElement annotatedElement) throws Exception {
        return new EFragmentHolder(environment, annotatedElement);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        super.validate(element, validation);
        this.validatorHelper.resIdsExist(element, IRClass.Res.LAYOUT, IdValidatorHelper.FallbackStrategy.ALLOW_NO_RES_ID, validation);
        this.validatorHelper.isNotPrivate(element, validation);
        this.validatorHelper.isAbstractOrHasEmptyConstructor(element, validation);
        this.validatorHelper.extendsFragment(element, validation);
        this.coreValidatorHelper.checkDataBoundAnnotation(element, validation);
    }

    @Override
    public void process(Element element, EFragmentHolder holder) {
        JFieldRef contentViewId = this.annotationHelper.extractOneAnnotationFieldRef(element, IRClass.Res.LAYOUT, false);
        if (contentViewId == null) {
            return;
        }
        JBlock block = holder.getSetContentViewBlock();
        JVar inflater = holder.getInflater();
        JVar container = holder.getContainer();
        JFieldVar contentView = holder.getContentView();
        boolean forceInjection = element.getAnnotation(EFragment.class).forceLayoutInjection();
        JBlock inflationBlock = !forceInjection ? block._if(contentView.eq((IJExpression)JExpr._null()))._then() : block;
        if (element.getAnnotation(DataBound.class) != null) {
            JFieldVar bindingField = holder.getDataBindingField();
            inflationBlock.assign((IJAssignmentTarget)bindingField, holder.getDataBindingInflationExpression((IJExpression)contentViewId, (IJExpression)container, false));
            inflationBlock.assign((IJAssignmentTarget)contentView, (IJExpression)bindingField.invoke("getRoot"));
            holder.getOnDestroyViewAfterSuperBlock().invoke((IJExpression)bindingField, "unbind");
            holder.clearInjectedView((IJAssignmentTarget)bindingField);
        } else {
            inflationBlock.assign((IJAssignmentTarget)contentView, (IJExpression)inflater.invoke("inflate").arg((IJExpression)contentViewId).arg((IJExpression)container).arg((IJExpression)JExpr.FALSE));
        }
    }
}

