/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.EBean;
import org.androidannotations.handler.BaseGeneratingAnnotationHandler;
import org.androidannotations.holder.EBeanHolder;

public class EBeanHandler
extends BaseGeneratingAnnotationHandler<EBeanHolder> {
    public EBeanHandler(AndroidAnnotationsEnvironment environment) {
        super(EBean.class, environment);
    }

    @Override
    public EBeanHolder createGeneratedClassHolder(AndroidAnnotationsEnvironment environment, TypeElement annotatedComponent) throws Exception {
        return new EBeanHolder(environment, annotatedComponent);
    }

    @Override
    public void validate(Element element, ElementValidation valid) {
        super.validate(element, valid);
        this.validatorHelper.isNotInterface((TypeElement)element, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.isAbstractOrHasEmptyOrContextConstructor(element, valid);
    }

    @Override
    public void process(Element element, EBeanHolder holder) {
        EBean eBeanAnnotation = element.getAnnotation(EBean.class);
        EBean.Scope eBeanScope = eBeanAnnotation.scope();
        boolean hasSingletonScope = eBeanScope == EBean.Scope.Singleton;
        holder.createFactoryMethod(hasSingletonScope);
        if (!hasSingletonScope) {
            holder.invokeInitInConstructor();
            holder.createRebindMethod();
        }
    }
}

