/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.DataBound;
import org.androidannotations.annotations.EActivity;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EActivityHolder;
import org.androidannotations.internal.core.handler.CoreBaseGeneratingAnnotationHandler;
import org.androidannotations.rclass.IRClass;

public class EActivityHandler
extends CoreBaseGeneratingAnnotationHandler<EActivityHolder> {
    public EActivityHandler(AndroidAnnotationsEnvironment environment) {
        super(EActivity.class, environment);
    }

    @Override
    public EActivityHolder createGeneratedClassHolder(AndroidAnnotationsEnvironment environment, TypeElement annotatedElement) throws Exception {
        return new EActivityHolder(environment, annotatedElement, this.getEnvironment().getAndroidManifest());
    }

    @Override
    public void validate(Element element, ElementValidation valid) {
        super.validate(element, valid);
        this.validatorHelper.extendsActivity(element, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.LAYOUT, IdValidatorHelper.FallbackStrategy.ALLOW_NO_RES_ID, valid);
        this.validatorHelper.componentRegistered(element, this.getEnvironment().getAndroidManifest(), valid);
        this.coreValidatorHelper.checkDataBoundAnnotation(element, valid);
    }

    @Override
    public void process(Element element, EActivityHolder holder) {
        List<JFieldRef> fieldRefs = this.annotationHelper.extractAnnotationFieldRefs(element, IRClass.Res.LAYOUT, false);
        JFieldRef contentViewId = null;
        if (fieldRefs.size() == 1) {
            contentViewId = fieldRefs.get(0);
        }
        if (contentViewId == null) {
            return;
        }
        JBlock onCreateBody = holder.getOnCreate().body();
        JMethod setContentView = holder.getSetContentViewLayout();
        if (element.getAnnotation(DataBound.class) != null) {
            JFieldRef androidContentResId = this.getEnvironment().getRClass().get(IRClass.Res.ID).getIdStaticRef(0x1020002, this.getEnvironment());
            JVar contentView = onCreateBody.decl((AbstractJType)this.getClasses().VIEW_GROUP, "contentView", (IJExpression)JExpr.invoke((String)"internalFindViewById").arg((IJExpression)androidContentResId));
            JFieldVar bindingField = holder.getDataBindingField();
            onCreateBody.assign((IJAssignmentTarget)bindingField, holder.getDataBindingInflationExpression((IJExpression)contentViewId, (IJExpression)contentView, false));
            onCreateBody.invoke(setContentView).arg((IJExpression)bindingField.invoke("getRoot")).arg((IJExpression)bindingField.invoke("getRoot").invoke("getLayoutParams"));
            holder.getOnDestroyBeforeSuperBlock().invoke((IJExpression)bindingField, "unbind");
        } else {
            onCreateBody.invoke(setContentView).arg((IJExpression)contentViewId);
        }
    }
}

