/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JFieldRef;
import javax.lang.model.element.Element;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.CustomTitle;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EActivityHolder;
import org.androidannotations.rclass.IRClass;

public class CustomTitleHandler
extends BaseAnnotationHandler<EActivityHolder> {
    public CustomTitleHandler(AndroidAnnotationsEnvironment environment) {
        super(CustomTitle.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.validatorHelper.hasEActivity(element, validation);
        this.validatorHelper.resIdsExist(element, IRClass.Res.LAYOUT, IdValidatorHelper.FallbackStrategy.NEED_RES_ID, validation);
    }

    @Override
    public void process(Element element, EActivityHolder holder) {
        JBlock onViewChangedBody = holder.getOnViewChangedBodyBeforeInjectionBlock();
        JFieldRef contentViewId = this.annotationHelper.extractAnnotationFieldRefs(element, this.getTarget(), this.getEnvironment().getRClass().get(IRClass.Res.LAYOUT), false).get(0);
        JFieldRef customTitleFeature = this.getClasses().WINDOW.staticRef("FEATURE_CUSTOM_TITLE");
        holder.getInitBodyInjectionBlock().invoke("requestWindowFeature").arg((IJExpression)customTitleFeature);
        onViewChangedBody.add((IJStatement)holder.getContextRef().invoke("getWindow").invoke("setFeatureInt").arg((IJExpression)customTitleFeature).arg((IJExpression)contentViewId));
    }
}

