/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JConditional;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JVar;
import javax.lang.model.element.TypeElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.internal.core.handler.AbstractResHandler;
import org.androidannotations.internal.core.model.AndroidRes;

abstract class ContextCompatAwareResHandler
extends AbstractResHandler {
    private final int minSdkWithMethod;
    private final String minSdkPlatformName;

    ContextCompatAwareResHandler(AndroidRes androidRes, AndroidAnnotationsEnvironment environment, int minSdkWithMethod, String minSdkPlatformName) {
        super(androidRes, environment);
        this.minSdkWithMethod = minSdkWithMethod;
        this.minSdkPlatformName = minSdkPlatformName;
    }

    @Override
    protected IJExpression getInstanceInvocation(EComponentHolder holder, JFieldRef idRef, IJAssignmentTarget fieldRef, JBlock targetBlock) {
        if (this.hasTargetMethodInAndroidxContextCompat()) {
            return this.getClasses().ANDROIDX_CONTEXT_COMPAT.staticInvoke(this.androidRes.getResourceMethodName()).arg(holder.getContextRef()).arg((IJExpression)idRef);
        }
        if (this.hasTargetMethodInContextCompat()) {
            return this.getClasses().CONTEXT_COMPAT.staticInvoke(this.androidRes.getResourceMethodName()).arg(holder.getContextRef()).arg((IJExpression)idRef);
        }
        if (this.shouldUseContextMethod()) {
            return holder.getContextRef().invoke(this.androidRes.getResourceMethodName()).arg((IJExpression)idRef);
        }
        if (!this.shouldUseContextMethod() && this.hasTargetMethodInContext()) {
            return this.createCallWithIfGuard(holder, idRef, fieldRef, targetBlock);
        }
        return JExpr.invoke((IJExpression)holder.getResourcesRef(), (String)this.androidRes.getResourceMethodName()).arg((IJExpression)idRef);
    }

    private boolean shouldUseContextMethod() {
        return this.getEnvironment().getAndroidManifest().getMinSdkVersion() >= this.minSdkWithMethod;
    }

    private boolean hasTargetMethodInContext() {
        TypeElement context = this.getProcessingEnvironment().getElementUtils().getTypeElement("android.content.Context");
        return this.hasTargetMethod(context, this.androidRes.getResourceMethodName());
    }

    private boolean hasTargetMethodInContextCompat() {
        TypeElement contextCompat = this.getProcessingEnvironment().getElementUtils().getTypeElement("android.support.v4.content.ContextCompat");
        return this.hasTargetMethod(contextCompat, this.androidRes.getResourceMethodName());
    }

    private boolean hasTargetMethodInAndroidxContextCompat() {
        TypeElement contextCompat = this.getProcessingEnvironment().getElementUtils().getTypeElement("androidx.core.content.ContextCompat");
        return this.hasTargetMethod(contextCompat, this.androidRes.getResourceMethodName());
    }

    private IJExpression createCallWithIfGuard(EComponentHolder holder, JFieldRef idRef, IJAssignmentTarget fieldRef, JBlock targetBlock) {
        JVar resourcesRef = holder.getResourcesRef();
        IJExpression buildVersionCondition = this.getClasses().BUILD_VERSION.staticRef("SDK_INT").gte((IJExpression)this.getClasses().BUILD_VERSION_CODES.staticRef(this.minSdkPlatformName));
        JConditional conditional = targetBlock._if(buildVersionCondition);
        conditional._then().add((IJStatement)fieldRef.assign((IJExpression)holder.getContextRef().invoke(this.androidRes.getResourceMethodName()).arg((IJExpression)idRef)));
        conditional._else().add((IJStatement)fieldRef.assign((IJExpression)resourcesRef.invoke(this.androidRes.getResourceMethodName()).arg((IJExpression)idRef)));
        return null;
    }
}

