/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.CheckedChange;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.ValidatorParameterHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.internal.core.handler.AbstractViewListenerHandler;

public class CheckedChangeHandler
extends AbstractViewListenerHandler {
    public CheckedChangeHandler(AndroidAnnotationsEnvironment environment) {
        super(CheckedChange.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        super.validate(element, validation);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoid(executableElement, validation);
        ((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)this.validatorHelper.param.anyOrder().extendsType("android.widget.CompoundButton")).optional()).primitiveOrWrapper(TypeKind.BOOLEAN)).optional()).validate(executableElement, validation);
    }

    @Override
    protected void makeCall(JBlock listenerMethodBody, JInvocation call, TypeMirror returnType) {
        listenerMethodBody.add((IJStatement)call);
    }

    @Override
    protected void processParameters(EComponentWithViewSupportHolder holder, JMethod listenerMethod, JInvocation call, List<? extends VariableElement> parameters) {
        JVar btnParam = listenerMethod.param((AbstractJType)this.getClasses().COMPOUND_BUTTON, "buttonView");
        JVar isCheckedParam = listenerMethod.param((AbstractJType)this.getCodeModel().BOOLEAN, "isChecked");
        for (VariableElement variableElement : parameters) {
            String parameterType = variableElement.asType().toString();
            if (this.isTypeOrSubclass("android.widget.CompoundButton", variableElement)) {
                call.arg(this.castArgumentIfNecessary(holder, "android.widget.CompoundButton", btnParam, variableElement));
                continue;
            }
            if (!parameterType.equals(CanonicalNameConstants.BOOLEAN) && variableElement.asType().getKind() != TypeKind.BOOLEAN) continue;
            call.arg((IJExpression)isCheckedParam);
        }
    }

    @Override
    protected JMethod createListenerMethod(JDefinedClass listenerAnonymousClass) {
        return listenerAnonymousClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onCheckedChanged");
    }

    @Override
    protected String getSetterName() {
        return "setOnCheckedChangeListener";
    }

    @Override
    protected AbstractJClass getListenerClass(EComponentWithViewSupportHolder holder) {
        return this.getClasses().COMPOUND_BUTTON_ON_CHECKED_CHANGE_LISTENER;
    }

    @Override
    protected AbstractJClass getListenerTargetClass(EComponentWithViewSupportHolder holder) {
        return this.getClasses().COMPOUND_BUTTON;
    }
}

