/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDirectClass;
import com.helger.jcodemodel.JExpr;
import java.util.Arrays;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.BindingObject;
import org.androidannotations.annotations.EFragment;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.InjectHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.EFragmentHolder;
import org.androidannotations.internal.core.handler.CoreBaseAnnotationHandler;
import org.androidannotations.internal.rclass.ProjectRClassFinder;

public class BindingObjectHandler
extends CoreBaseAnnotationHandler<EComponentWithViewSupportHolder>
implements MethodInjectionHandler<EComponentWithViewSupportHolder> {
    private final InjectHelper<EComponentWithViewSupportHolder> injectHelper;

    public BindingObjectHandler(AndroidAnnotationsEnvironment environment) {
        super(BindingObject.class, environment);
        this.injectHelper = new InjectHelper<EComponentWithViewSupportHolder>(this.validatorHelper, this);
    }

    @Override
    protected void validate(Element element, ElementValidation validation) {
        if (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.PARAMETER) {
            ExecutableElement methodElement = (ExecutableElement)(element.getKind() == ElementKind.METHOD ? element : element.getEnclosingElement());
            this.validatorHelper.param.extendsAnyOfTypes("android.databinding.ViewDataBinding", "androidx.databinding.ViewDataBinding").validate(methodElement, validation);
            if (!validation.isValid()) {
                return;
            }
        }
        this.injectHelper.validate(BindingObject.class, element, validation);
        if (validation.isValid()) {
            this.validatorHelper.isNotPrivate(element, validation);
            this.validatorHelper.extendsOneOfTypes(this.injectHelper.getParam(element), Arrays.asList("android.databinding.ViewDataBinding", "androidx.databinding.ViewDataBinding"), validation);
        }
    }

    @Override
    public void validateEnclosingElement(Element element, ElementValidation valid) {
        this.coreValidatorHelper.checkDataBoundAnnotation(element.getEnclosingElement(), valid);
        this.coreValidatorHelper.hasEActivityOrEFragmentOrEViewGroup(element.getEnclosingElement(), element, valid);
        this.coreValidatorHelper.enclosingElementHasDataBoundAnnotation(element, valid);
    }

    @Override
    public void process(Element element, EComponentWithViewSupportHolder holder) throws Exception {
        this.injectHelper.process(element, holder);
        if (element.getKind() == ElementKind.FIELD && holder instanceof EFragment) {
            ((EFragmentHolder)holder).clearInjectedView((IJAssignmentTarget)JExpr._this().ref(element.getSimpleName().toString()));
        }
    }

    @Override
    public JBlock getInvocationBlock(EComponentWithViewSupportHolder holder) {
        return holder.getOnViewChangedBodyAfterInjectionBlock();
    }

    @Override
    public void assignValue(JBlock targetBlock, IJAssignmentTarget fieldRef, EComponentWithViewSupportHolder holder, Element element, Element param) {
        String bindingClassQualifiedName;
        if (!param.asType().toString().contains(".")) {
            String resourcePackageName = this.getEnvironment().getOptionValue(ProjectRClassFinder.OPTION_RESOURCE_PACKAGE_NAME);
            if (resourcePackageName == null) {
                resourcePackageName = this.getEnvironment().getAndroidManifest().getApplicationPackage();
            }
            bindingClassQualifiedName = resourcePackageName + ".databinding." + param.asType().toString();
        } else {
            bindingClassQualifiedName = param.asType().toString();
        }
        JDirectClass bindingClass = this.getCodeModel().directClass(bindingClassQualifiedName);
        targetBlock.add((IJStatement)fieldRef.assign((IJExpression)JExpr.cast((AbstractJType)bindingClass, (IJExpression)holder.getDataBindingField())));
    }
}

