/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAssignment;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JConditional;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JInvocation;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.Bean;
import org.androidannotations.annotations.EBean;
import org.androidannotations.annotations.NonConfigurationInstance;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.InjectHelper;
import org.androidannotations.holder.EBeanHolder;
import org.androidannotations.holder.EComponentHolder;

public class BeanHandler
extends BaseAnnotationHandler<EComponentHolder>
implements MethodInjectionHandler<EComponentHolder> {
    private final InjectHelper<EComponentHolder> injectHelper;

    public BeanHandler(AndroidAnnotationsEnvironment environment) {
        super(Bean.class, environment);
        this.injectHelper = new InjectHelper<EComponentHolder>(this.validatorHelper, this);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.injectHelper.validate(Bean.class, element, validation);
        if (!validation.isValid()) {
            return;
        }
        this.validatorHelper.typeOrTargetValueHasAnnotation(EBean.class, element, validation);
        this.validatorHelper.isNotPrivate(element, validation);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        this.injectHelper.process(element, holder);
    }

    @Override
    public JBlock getInvocationBlock(EComponentHolder holder) {
        return holder.getInitBodyInjectionBlock();
    }

    @Override
    public void assignValue(JBlock targetBlock, IJAssignmentTarget fieldRef, EComponentHolder holder, Element element, Element param) {
        TypeMirror typeMirror = this.annotationHelper.extractAnnotationClassParameter(element);
        if (typeMirror == null) {
            typeMirror = param.asType();
            typeMirror = this.getProcessingEnvironment().getTypeUtils().erasure(typeMirror);
        }
        String typeQualifiedName = typeMirror.toString();
        AbstractJClass injectedClass = this.getJClass(this.annotationHelper.generatedClassQualifiedNameFromQualifiedName(typeQualifiedName));
        JInvocation beanInstance = injectedClass.staticInvoke(EBeanHolder.GET_INSTANCE_METHOD_NAME).arg(holder.getContextRef());
        JAssignment assignment = fieldRef.assign((IJExpression)beanInstance);
        if (param.getKind() == ElementKind.FIELD) {
            boolean hasNonConfigurationInstanceAnnotation;
            boolean bl = hasNonConfigurationInstanceAnnotation = element.getAnnotation(NonConfigurationInstance.class) != null;
            if (hasNonConfigurationInstanceAnnotation) {
                JConditional conditional = targetBlock._if(fieldRef.eq((IJExpression)JExpr._null()));
                conditional._then().add((IJStatement)assignment);
                assignment = conditional;
            }
        }
        targetBlock.add((IJStatement)assignment);
    }

    @Override
    public void validateEnclosingElement(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, valid);
    }
}

