/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAnonymousClass;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCatchBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JTryBlock;
import com.helger.jcodemodel.JVar;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.annotations.Background;
import org.androidannotations.api.BackgroundExecutor;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.internal.core.handler.AbstractRunnableHandler;

public class BackgroundHandler
extends AbstractRunnableHandler {
    public BackgroundHandler(AndroidAnnotationsEnvironment environment) {
        super(Background.class, environment);
    }

    @Override
    public void process(Element element, EComponentHolder holder) throws Exception {
        ExecutableElement executableElement = (ExecutableElement)element;
        JMethod delegatingMethod = this.codeModelHelper.overrideAnnotatedMethod(executableElement, holder);
        JBlock previousMethodBody = this.codeModelHelper.removeBody(delegatingMethod);
        JAnonymousClass anonymousTaskClass = this.getCodeModel().anonymousClass(BackgroundExecutor.Task.class);
        JMethod executeMethod = anonymousTaskClass.method(1, (AbstractJType)this.getCodeModel().VOID, "execute");
        executeMethod.annotate(Override.class);
        JTryBlock tryBlock = executeMethod.body()._try();
        tryBlock.body().add((IJStatement)previousMethodBody);
        JCatchBlock catchBlock = tryBlock._catch(this.getClasses().THROWABLE);
        JVar caughtException = catchBlock.param("e");
        JInvocation uncaughtExceptionCall = this.getClasses().THREAD.staticInvoke("getDefaultUncaughtExceptionHandler").invoke("uncaughtException").arg((IJExpression)this.getClasses().THREAD.staticInvoke("currentThread")).arg((IJExpression)caughtException);
        catchBlock.body().add((IJStatement)uncaughtExceptionCall);
        Background annotation = element.getAnnotation(Background.class);
        String id = annotation.id();
        long delay = annotation.delay();
        String serial = annotation.serial();
        AbstractJClass backgroundExecutorClass = this.getJClass(BackgroundExecutor.class);
        JInvocation newTask = JExpr._new((AbstractJClass)anonymousTaskClass).arg((IJExpression)JExpr.lit((String)id)).arg((IJExpression)JExpr.lit((long)delay)).arg((IJExpression)JExpr.lit((String)serial));
        JInvocation executeCall = backgroundExecutorClass.staticInvoke("execute").arg((IJExpression)newTask);
        delegatingMethod.body().add((IJStatement)executeCall);
    }
}

