/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import javax.lang.model.element.Element;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.App;
import org.androidannotations.annotations.EApplication;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.InjectHelper;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.EComponentHolder;

public class AppHandler
extends BaseAnnotationHandler<EComponentHolder>
implements MethodInjectionHandler<EComponentHolder> {
    private final InjectHelper<EComponentHolder> injectHelper;

    public AppHandler(AndroidAnnotationsEnvironment environment) {
        super(App.class, environment);
        this.injectHelper = new InjectHelper<EComponentHolder>(this.validatorHelper, this);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.injectHelper.validate(App.class, element, validation);
        if (!validation.isValid()) {
            return;
        }
        this.validatorHelper.isNotPrivate(element, validation);
        Element param = this.injectHelper.getParam(element);
        this.validatorHelper.typeHasValidAnnotation(EApplication.class, param, validation);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        this.injectHelper.process(element, holder);
    }

    @Override
    public JBlock getInvocationBlock(EComponentHolder holder) {
        return holder.getInitBodyInjectionBlock();
    }

    @Override
    public void assignValue(JBlock targetBlock, IJAssignmentTarget fieldRef, EComponentHolder holder, Element element, Element param) {
        String applicationQualifiedName = param.asType().toString();
        AbstractJClass applicationClass = this.getJClass(applicationQualifiedName + ModelConstants.classSuffix());
        targetBlock.add((IJStatement)fieldRef.assign((IJExpression)applicationClass.staticInvoke("getInstance")));
    }

    @Override
    public void validateEnclosingElement(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, valid);
    }
}

