/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.AfterTextChange;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.helper.ValidatorParameterHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.TextWatcherHolder;
import org.androidannotations.internal.core.handler.CoreBaseAnnotationHandler;
import org.androidannotations.rclass.IRClass;

public class AfterTextChangeHandler
extends CoreBaseAnnotationHandler<EComponentWithViewSupportHolder> {
    public AfterTextChangeHandler(AndroidAnnotationsEnvironment environment) {
        super(AfterTextChange.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, validation);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, validation);
        this.validatorHelper.isNotPrivate(element, validation);
        this.validatorHelper.doesntThrowException(element, validation);
        this.validatorHelper.returnTypeIsVoid((ExecutableElement)element, validation);
        this.coreValidatorHelper.hasAfterTextChangedMethodParameters((ExecutableElement)element, validation);
        ((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)this.validatorHelper.param.anyOrder().type("android.widget.TextView")).optional()).type("android.text.Editable")).optional()).validate((ExecutableElement)element, validation);
    }

    @Override
    public void process(Element element, EComponentWithViewSupportHolder holder) throws Exception {
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        int editableParameterPosition = -1;
        int viewParameterPosition = -1;
        TypeMirror viewParameterType = null;
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            TypeMirror parameterType = parameter.asType();
            if ("android.text.Editable".equals(parameterType.toString())) {
                editableParameterPosition = i;
                continue;
            }
            TypeMirror textViewType = this.annotationHelper.typeElementFromQualifiedName("android.widget.TextView").asType();
            if (!this.annotationHelper.isSubtype(parameterType, textViewType)) continue;
            viewParameterPosition = i;
            viewParameterType = parameterType;
        }
        List<JFieldRef> idsRefs = this.annotationHelper.extractAnnotationFieldRefs(element, IRClass.Res.ID, true);
        for (JFieldRef idRef : idsRefs) {
            TextWatcherHolder textWatcherHolder = holder.getTextWatcherHolder(idRef, viewParameterType);
            JBlock methodBody = textWatcherHolder.getAfterTextChangedBody();
            JFieldRef activityRef = holder.getGeneratedClass().staticRef("this");
            JInvocation textChangeCall = methodBody.invoke((IJExpression)activityRef, methodName);
            for (int i = 0; i < parameters.size(); ++i) {
                if (i == editableParameterPosition) {
                    JVar afterTextChangeEditableParam = textWatcherHolder.getAfterTextChangedEditableParam();
                    textChangeCall.arg((IJExpression)afterTextChangeEditableParam);
                    continue;
                }
                if (i != viewParameterPosition) continue;
                JVar viewParameter = textWatcherHolder.getTextViewVariable();
                textChangeCall.arg((IJExpression)viewParameter);
            }
        }
    }
}

