/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import java.util.List;
import javax.lang.model.element.Element;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.FoundViewHolder;
import org.androidannotations.internal.core.handler.AbstractListenerHandler;
import org.androidannotations.rclass.IRClass;

public abstract class AbstractViewListenerHandler
extends AbstractListenerHandler<EComponentWithViewSupportHolder> {
    public AbstractViewListenerHandler(Class<?> targetClass, AndroidAnnotationsEnvironment environment) {
        super(targetClass, environment);
    }

    public AbstractViewListenerHandler(String target, AndroidAnnotationsEnvironment environment) {
        super(target, environment);
    }

    @Override
    public void validate(Element element, ElementValidation valid) {
        super.validate(element, valid);
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, valid);
    }

    @Override
    protected final void assignListeners(EComponentWithViewSupportHolder holder, List<JFieldRef> idsRefs, JDefinedClass listenerAnonymousClass) {
        for (JFieldRef idRef : idsRefs) {
            AbstractJClass listenerTargetClass = this.getListenerTargetClass(holder);
            FoundViewHolder foundViewHolder = holder.getFoundViewHolder(idRef, listenerTargetClass);
            foundViewHolder.getIfNotNullBlock().invoke(foundViewHolder.getOrCastRef(listenerTargetClass), this.getSetterName()).arg((IJExpression)JExpr._new((AbstractJClass)listenerAnonymousClass));
        }
    }

    @Override
    protected AbstractJClass getListenerTargetClass(EComponentWithViewSupportHolder holder) {
        return this.getClasses().VIEW;
    }

    @Override
    protected final IRClass.Res getResourceType() {
        return IRClass.Res.ID;
    }
}

