/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.OnSeekBarChangeListenerHolder;
import org.androidannotations.internal.core.handler.CoreBaseAnnotationHandler;
import org.androidannotations.rclass.IRClass;

public abstract class AbstractSeekBarTouchHandler
extends CoreBaseAnnotationHandler<EComponentWithViewSupportHolder> {
    public AbstractSeekBarTouchHandler(Class<?> targetClass, AndroidAnnotationsEnvironment environment) {
        super(targetClass, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, validation);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, validation);
        this.validatorHelper.isNotPrivate(element, validation);
        this.validatorHelper.doesntThrowException(element, validation);
        this.validatorHelper.returnTypeIsVoid((ExecutableElement)element, validation);
        this.coreValidatorHelper.hasSeekBarTouchTrackingMethodParameters((ExecutableElement)element, validation);
        this.validatorHelper.param.type("android.widget.SeekBar").optional().validate((ExecutableElement)element, validation);
    }

    @Override
    public void process(Element element, EComponentWithViewSupportHolder holder) throws Exception {
        String methodName = element.getSimpleName().toString();
        List<JFieldRef> idsRefs = this.annotationHelper.extractAnnotationFieldRefs(element, IRClass.Res.ID, true);
        for (JFieldRef idRef : idsRefs) {
            OnSeekBarChangeListenerHolder onSeekBarChangeListenerHolder = holder.getOnSeekBarChangeListenerHolder(idRef);
            JBlock methodBody = this.getMethodBodyToCall(onSeekBarChangeListenerHolder);
            JFieldRef activityRef = holder.getGeneratedClass().staticRef("this");
            JInvocation textChangeCall = methodBody.invoke((IJExpression)activityRef, methodName);
            ExecutableElement executableElement = (ExecutableElement)element;
            List<? extends VariableElement> parameters = executableElement.getParameters();
            if (parameters.size() != 1) continue;
            JVar progressParameter = this.getMethodParamToPass(onSeekBarChangeListenerHolder);
            textChangeCall.arg((IJExpression)progressParameter);
        }
    }

    protected abstract JBlock getMethodBodyToCall(OnSeekBarChangeListenerHolder var1);

    protected abstract JVar getMethodParamToPass(OnSeekBarChangeListenerHolder var1);
}

