/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JFieldRef;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.helper.InjectHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.internal.core.model.AndroidRes;
import org.androidannotations.rclass.IRClass;

public abstract class AbstractResHandler
extends BaseAnnotationHandler<EComponentHolder>
implements MethodInjectionHandler<EComponentHolder> {
    private final InjectHelper<EComponentHolder> injectHelper;
    protected AndroidRes androidRes;

    public AbstractResHandler(AndroidRes androidRes, AndroidAnnotationsEnvironment environment) {
        super(androidRes.getAnnotationClass(), environment);
        this.androidRes = androidRes;
        this.injectHelper = new InjectHelper<EComponentHolder>(this.validatorHelper, this);
    }

    @Override
    public final void validate(Element element, ElementValidation validation) {
        this.injectHelper.validate(this.androidRes.getAnnotationClass(), element, validation);
        if (!validation.isValid()) {
            return;
        }
        this.validatorHelper.allowedType(element, this.androidRes.getAllowedTypes(), validation);
        this.validatorHelper.resIdsExist(element, this.androidRes.getRInnerClass(), IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, validation);
        Element enclosingElement = element.getEnclosingElement();
        if (element instanceof VariableElement && enclosingElement instanceof ExecutableElement) {
            this.validatorHelper.isNotPrivate(enclosingElement, validation);
        } else {
            this.validatorHelper.isNotPrivate(element, validation);
        }
    }

    @Override
    public final void process(Element element, EComponentHolder holder) {
        this.injectHelper.process(element, holder);
    }

    @Override
    public JBlock getInvocationBlock(EComponentHolder holder) {
        return holder.getInitBodyInjectionBlock();
    }

    @Override
    public void assignValue(JBlock targetBlock, IJAssignmentTarget fieldRef, EComponentHolder holder, Element element, Element param) {
        IRClass.Res resInnerClass = this.androidRes.getRInnerClass();
        JFieldRef idRef = this.annotationHelper.extractOneAnnotationFieldRef(element, resInnerClass, true);
        IJExpression resourceInstance = this.getInstanceInvocation(holder, idRef, fieldRef, targetBlock);
        if (resourceInstance != null) {
            targetBlock.add((IJStatement)fieldRef.assign(resourceInstance));
        }
    }

    @Override
    public void validateEnclosingElement(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, valid);
    }

    protected abstract IJExpression getInstanceInvocation(EComponentHolder var1, JFieldRef var2, IJAssignmentTarget var3, JBlock var4);
}

