/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.rclass.IRClass;

public abstract class AbstractPageChangeHandler
extends BaseAnnotationHandler<EComponentWithViewSupportHolder> {
    public AbstractPageChangeHandler(Class<?> targetClass, AndroidAnnotationsEnvironment environment) {
        super(targetClass, environment);
    }

    @Override
    protected void validate(Element element, ElementValidation validation) {
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, validation);
        this.validatorHelper.isViewPagerClassPresent(validation);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, validation);
        this.validatorHelper.isNotPrivate(element, validation);
        this.validatorHelper.doesntThrowException(element, validation);
        this.validatorHelper.returnTypeIsVoid((ExecutableElement)element, validation);
        this.validatorHelper.uniqueResourceId(element, IRClass.Res.ID, validation);
    }

    protected boolean hasAddOnPageChangeListenerMethod() {
        TypeElement viewPager = this.getProcessingEnvironment().getElementUtils().getTypeElement("android.support.v4.view.ViewPager");
        TypeElement androidxViewPager = this.getProcessingEnvironment().getElementUtils().getTypeElement("androidx.viewpager.widget.ViewPager");
        return this.hasTargetMethod(viewPager, "addOnPageChangeListener") || this.hasTargetMethod(androidxViewPager, "addOnPageChangeListener");
    }

    protected boolean isViewPagerParameter(TypeMirror parameterType) {
        TypeElement viewPagerTypeElement = this.annotationHelper.typeElementFromQualifiedName("android.support.v4.view.ViewPager");
        TypeElement androidxViewPagerTypeElement = this.annotationHelper.typeElementFromQualifiedName("androidx.viewpager.widget.ViewPager");
        TypeMirror viewPagerType = viewPagerTypeElement == null ? null : viewPagerTypeElement.asType();
        TypeMirror androidxViewPagerType = androidxViewPagerTypeElement == null ? null : androidxViewPagerTypeElement.asType();
        return viewPagerType != null && this.annotationHelper.isSubtype(parameterType, viewPagerType) || androidxViewPagerType != null && this.annotationHelper.isSubtype(parameterType, androidxViewPagerType);
    }
}

