/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JAnonymousClass;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.rclass.IRClass;

public abstract class AbstractListenerHandler<T extends GeneratedClassHolder>
extends BaseAnnotationHandler<T> {
    private T holder;
    private String methodName;

    public AbstractListenerHandler(Class<?> targetClass, AndroidAnnotationsEnvironment environment) {
        super(targetClass, environment);
    }

    public AbstractListenerHandler(String target, AndroidAnnotationsEnvironment environment) {
        super(target, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, validation);
        this.validatorHelper.resIdsExist(element, this.getResourceType(), IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, validation);
        this.validatorHelper.isNotPrivate(element, validation);
        this.validatorHelper.doesntThrowException(element, validation);
        this.validatorHelper.uniqueResourceId(element, this.getResourceType(), validation);
    }

    @Override
    public void process(Element element, T holder) {
        this.holder = holder;
        this.methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        TypeMirror returnType = executableElement.getReturnType();
        List<JFieldRef> idsRefs = this.annotationHelper.extractAnnotationFieldRefs(element, this.getResourceType(), true);
        JAnonymousClass listenerAnonymousClass = this.getCodeModel().anonymousClass(this.getListenerClass(holder));
        JMethod listenerMethod = this.createListenerMethod((JDefinedClass)listenerAnonymousClass);
        listenerMethod.annotate(Override.class);
        JBlock listenerMethodBody = listenerMethod.body();
        JFieldRef activityRef = holder.getGeneratedClass().staticRef("this");
        JInvocation call = JExpr.invoke((IJExpression)activityRef, (String)this.methodName);
        this.makeCall(listenerMethodBody, call, returnType);
        this.processParameters(holder, listenerMethod, call, parameters);
        this.assignListeners(holder, idsRefs, (JDefinedClass)listenerAnonymousClass);
    }

    protected final IJExpression castArgumentIfNecessary(T holder, String baseType, JVar param, Element element) {
        JVar argument = param;
        TypeMirror typeMirror = element.asType();
        if (!baseType.equals(typeMirror.toString())) {
            AbstractJClass typeMirrorToJClass = this.codeModelHelper.typeMirrorToJClass(typeMirror);
            argument = JExpr.cast((AbstractJType)typeMirrorToJClass, (IJExpression)param);
        }
        return argument;
    }

    protected final boolean isTypeOrSubclass(String baseType, Element element) {
        TypeMirror typeMirror = element.asType();
        TypeElement typeElement = this.annotationHelper.typeElementFromQualifiedName(baseType);
        return typeElement != null && this.annotationHelper.isSubtype(typeMirror, typeElement.asType());
    }

    protected abstract void assignListeners(T var1, List<JFieldRef> var2, JDefinedClass var3);

    protected abstract void makeCall(JBlock var1, JInvocation var2, TypeMirror var3);

    protected abstract void processParameters(T var1, JMethod var2, JInvocation var3, List<? extends VariableElement> var4);

    protected abstract JMethod createListenerMethod(JDefinedClass var1);

    protected abstract String getSetterName();

    protected abstract AbstractJClass getListenerClass(T var1);

    protected abstract AbstractJClass getListenerTargetClass(T var1);

    protected String getMethodName() {
        return this.methodName;
    }

    protected final T getHolder() {
        return this.holder;
    }

    protected abstract IRClass.Res getResourceType();
}

