/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JSwitch;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.helper.KeyCodeHelper;
import org.androidannotations.helper.ValidatorParameterHelper;
import org.androidannotations.holder.HasKeyEventCallbackMethods;
import org.androidannotations.internal.core.handler.CoreBaseAnnotationHandler;

public abstract class AbstractKeyEventHandler
extends CoreBaseAnnotationHandler<HasKeyEventCallbackMethods> {
    protected final KeyCodeHelper annotationHelper;

    public AbstractKeyEventHandler(Class<?> targetClass, AndroidAnnotationsEnvironment environment) {
        super(targetClass, environment);
        this.annotationHelper = new KeyCodeHelper(environment, this.getTarget());
    }

    @Override
    protected void validate(Element element, ElementValidation validation) {
        this.coreValidatorHelper.enclosingElementExtendsKeyEventCallback(element, validation);
        this.validatorHelper.isNotPrivate(element, validation);
        this.validatorHelper.doesntThrowException(element, validation);
        if (!this.annotationHelper.uniqueKeyCode(element, this.getTarget())) {
            validation.addError(element, "%s " + element.getSimpleName() + " keyCode is not unique");
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoidOrBoolean(executableElement, validation);
        String[] paramTypes = this.getParamTypes();
        ValidatorParameterHelper.AnyOrderParamValidator param = this.validatorHelper.param.anyOrder();
        if (paramTypes.length > 0) {
            for (String paramType : paramTypes) {
                ((ValidatorParameterHelper.AnyOrderParamValidator)param.type(paramType)).optional();
            }
            param.validate(executableElement, validation);
        }
    }

    @Override
    public void process(Element element, HasKeyEventCallbackMethods holder) throws Exception {
        int[] keyCodes;
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        TypeMirror returnType = executableElement.getReturnType();
        boolean returnMethodResult = returnType.getKind() != TypeKind.VOID;
        JSwitch switchBody = this.getSwitchBody(holder);
        for (int keyCode : keyCodes = this.annotationHelper.extractKeyCode(element)) {
            String keyCodeFieldName = this.annotationHelper.getFieldNameForKeyCode(keyCode);
            JBlock switchCaseBody = switchBody._case((IJExpression)this.getClasses().KEY_EVENT.staticRef(keyCodeFieldName)).body();
            JInvocation methodCall = JExpr.invoke((String)methodName);
            if (returnMethodResult) {
                switchCaseBody._return((IJExpression)methodCall);
            } else {
                switchCaseBody.add((IJStatement)methodCall);
                switchCaseBody._return((IJExpression)JExpr.TRUE);
            }
            this.passParametersToMethodCall(element, holder, methodCall);
        }
    }

    public abstract String[] getParamTypes();

    public abstract JSwitch getSwitchBody(HasKeyEventCallbackMethods var1);

    public abstract void passParametersToMethodCall(Element var1, HasKeyEventCallbackMethods var2, JInvocation var3);
}

