/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JMethod;
import java.lang.annotation.Annotation;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.InjectHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.EFragmentHolder;
import org.androidannotations.internal.core.handler.CoreBaseAnnotationHandler;

public abstract class AbstractFragmentByHandler
extends CoreBaseAnnotationHandler<EComponentWithViewSupportHolder>
implements MethodInjectionHandler<EComponentWithViewSupportHolder> {
    private final InjectHelper<EComponentWithViewSupportHolder> injectHelper;
    private Class<? extends Annotation> targetClass;
    protected String findFragmentMethodName;

    public AbstractFragmentByHandler(Class<? extends Annotation> targetClass, AndroidAnnotationsEnvironment environment, String findFragmentMethodName) {
        super(targetClass, environment);
        this.targetClass = targetClass;
        this.findFragmentMethodName = findFragmentMethodName;
        this.injectHelper = new InjectHelper<EComponentWithViewSupportHolder>(this.validatorHelper, this);
    }

    @Override
    protected void validate(Element element, ElementValidation validation) {
        this.injectHelper.validate(this.targetClass, element, validation);
        if (!validation.isValid()) {
            return;
        }
        Element param = element;
        if (element instanceof ExecutableElement) {
            param = ((ExecutableElement)element).getParameters().get(0);
        }
        this.validatorHelper.extendsFragment(param, validation);
        this.validatorHelper.isNotPrivate(element, validation);
        this.coreValidatorHelper.childFragmentUsedOnlyIfEnclosingClassIsFragment(element, validation);
        if (validation.isValid()) {
            this.coreValidatorHelper.getChildFragmentManagerMethodIsAvailable(element, validation);
        }
    }

    @Override
    public final void process(Element element, EComponentWithViewSupportHolder holder) throws Exception {
        this.injectHelper.process(element, holder);
    }

    @Override
    public JBlock getInvocationBlock(EComponentWithViewSupportHolder holder) {
        return holder.getOnViewChangedBodyInjectionBlock();
    }

    @Override
    public void assignValue(JBlock targetBlock, IJAssignmentTarget fieldRef, EComponentWithViewSupportHolder holder, Element element, Element param) {
        TypeMirror elementType = param.asType();
        String typeQualifiedName = elementType.toString();
        TypeElement nativeFragmentElement = this.annotationHelper.typeElementFromQualifiedName("android.app.Fragment");
        boolean isNativeFragment = nativeFragmentElement != null && this.annotationHelper.isSubtype(elementType, nativeFragmentElement.asType());
        String fieldName = element.getSimpleName().toString();
        if (holder instanceof EFragmentHolder) {
            boolean childFragment = (Boolean)this.annotationHelper.extractAnnotationParameter(element, "childFragment");
            String fragmentManagerGetter = childFragment ? "getChildFragmentManager" : "getFragmentManager";
            targetBlock.add((IJStatement)fieldRef.assign((IJExpression)JExpr.cast((AbstractJType)this.getJClass(typeQualifiedName), (IJExpression)JExpr.invoke((String)fragmentManagerGetter).invoke(this.findFragmentMethodName).arg(this.getFragmentId(element, fieldName)))));
        } else {
            JMethod findFragmentMethod = this.getFindFragmentMethod(isNativeFragment, holder);
            targetBlock.add((IJStatement)fieldRef.assign((IJExpression)JExpr.cast((AbstractJType)this.getJClass(typeQualifiedName), (IJExpression)JExpr.invoke((JMethod)findFragmentMethod).arg(this.getFragmentId(element, fieldName)))));
        }
    }

    @Override
    public void validateEnclosingElement(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, valid);
    }

    protected abstract JMethod getFindFragmentMethod(boolean var1, EComponentWithViewSupportHolder var2);

    protected abstract IJExpression getFragmentId(Element var1, String var2);
}

