/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import org.androidannotations.Option;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.BaseGeneratedClassHolder;
import org.androidannotations.internal.generation.CodeModelGenerator;
import org.androidannotations.internal.helper.AndroidManifestFinder;
import org.androidannotations.internal.rclass.ProjectRClassFinder;
import org.androidannotations.logger.LoggerContext;
import org.androidannotations.logger.appender.FileAppender;

public class Options {
    private final Map<String, Option> supportedOptions = new HashMap<String, Option>();
    private final Map<String, String> options;

    public Options(ProcessingEnvironment processingEnvironment) {
        this.options = processingEnvironment.getOptions();
        this.addSupportedOption(AndroidManifestFinder.OPTION_MANIFEST);
        this.addSupportedOption(AndroidManifestFinder.OPTION_LIBRARY);
        this.addSupportedOption(ProjectRClassFinder.OPTION_RESOURCE_PACKAGE_NAME);
        this.addSupportedOption(ProjectRClassFinder.OPTION_USE_R2);
        this.addSupportedOption(ModelConstants.OPTION_CLASS_SUFFIX);
        this.addSupportedOption(FileAppender.OPTION_LOG_FILE);
        this.addSupportedOption(LoggerContext.OPTION_LOG_LEVEL);
        this.addSupportedOption(LoggerContext.OPTION_LOG_APPENDER_CONSOLE);
        this.addSupportedOption(LoggerContext.OPTION_LOG_APPENDER_FILE);
        this.addSupportedOption(BaseGeneratedClassHolder.OPTION_GENERATE_FINAL_CLASSES);
        this.addSupportedOption(CodeModelGenerator.OPTION_ENCODING);
    }

    public void addAllSupportedOptions(List<Option> options) {
        for (Option option : options) {
            this.addSupportedOption(option);
        }
    }

    private void addSupportedOption(Option option) {
        this.supportedOptions.put(option.getName(), option);
    }

    public String get(Option option) {
        String value = this.options.get(option.getName());
        return value != null ? value : option.getDefaultValue();
    }

    public String get(String optionKey) {
        Option option = this.supportedOptions.get(optionKey);
        if (option != null) {
            return this.get(option);
        }
        return this.options.get(optionKey);
    }

    public boolean getBoolean(Option option) {
        return Boolean.valueOf(this.get(option));
    }

    public boolean getBoolean(String optionKey) {
        return Boolean.valueOf(this.get(optionKey));
    }

    public Set<String> getSupportedOptions() {
        return this.supportedOptions.keySet();
    }
}

