/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.Option;
import org.androidannotations.handler.AnnotationHandler;
import org.androidannotations.handler.GeneratingAnnotationHandler;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.internal.AnnotationHandlers;
import org.androidannotations.internal.Options;
import org.androidannotations.internal.model.AnnotationElements;
import org.androidannotations.internal.process.ProcessHolder;
import org.androidannotations.plugin.AndroidAnnotationsPlugin;
import org.androidannotations.rclass.IRClass;

public class InternalAndroidAnnotationsEnvironment
implements AndroidAnnotationsEnvironment {
    private final ProcessingEnvironment processingEnvironment;
    private final Options options;
    private final AnnotationHandlers annotationHandlers;
    private List<AndroidAnnotationsPlugin> plugins;
    private IRClass rClass;
    private AndroidManifest androidManifest;
    private AnnotationElements extractedElements;
    private AnnotationElements validatedElements;
    private ProcessHolder processHolder;

    InternalAndroidAnnotationsEnvironment(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.options = new Options(processingEnvironment);
        this.annotationHandlers = new AnnotationHandlers();
    }

    public void setPlugins(List<AndroidAnnotationsPlugin> plugins) {
        this.plugins = plugins;
        for (AndroidAnnotationsPlugin plugin : plugins) {
            this.options.addAllSupportedOptions(plugin.getSupportedOptions());
            for (AnnotationHandler<?> annotationHandler : plugin.getHandlers(this)) {
                this.annotationHandlers.add(annotationHandler);
            }
        }
    }

    public void setAndroidEnvironment(IRClass rClass, AndroidManifest androidManifest) {
        this.rClass = rClass;
        this.androidManifest = androidManifest;
    }

    public void setExtractedElements(AnnotationElements extractedElements) {
        this.extractedElements = extractedElements;
    }

    public void setValidatedElements(AnnotationElements validatedElements) {
        this.validatedElements = validatedElements;
    }

    public void setProcessHolder(ProcessHolder processHolder) {
        this.processHolder = processHolder;
    }

    @Override
    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnvironment;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return this.options.getSupportedOptions();
    }

    @Override
    public String getOptionValue(Option option) {
        return this.options.get(option);
    }

    @Override
    public String getOptionValue(String optionKey) {
        return this.options.get(optionKey);
    }

    @Override
    public boolean getOptionBooleanValue(Option option) {
        return this.options.getBoolean(option);
    }

    @Override
    public boolean getOptionBooleanValue(String optionKey) {
        return this.options.getBoolean(optionKey);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.annotationHandlers.getSupportedAnnotationTypes();
    }

    @Override
    public List<AnnotationHandler<?>> getHandlers() {
        return this.annotationHandlers.get();
    }

    @Override
    public List<AnnotationHandler<?>> getDecoratingHandlers() {
        return this.annotationHandlers.getDecorating();
    }

    @Override
    public List<GeneratingAnnotationHandler<?>> getGeneratingHandlers() {
        return this.annotationHandlers.getGenerating();
    }

    @Override
    public IRClass getRClass() {
        return this.rClass;
    }

    @Override
    public AndroidManifest getAndroidManifest() {
        return this.androidManifest;
    }

    @Override
    public AnnotationElements getExtractedElements() {
        return this.extractedElements;
    }

    @Override
    public AnnotationElements getValidatedElements() {
        return this.validatedElements;
    }

    @Override
    public JCodeModel getCodeModel() {
        return this.processHolder.codeModel();
    }

    @Override
    public AbstractJClass getJClass(String fullyQualifiedName) {
        return this.processHolder.refClass(fullyQualifiedName);
    }

    @Override
    public AbstractJClass getJClass(Class<?> clazz) {
        return this.processHolder.refClass(clazz);
    }

    @Override
    public JDefinedClass getDefinedClass(String fullyQualifiedName) {
        return this.processHolder.definedClass(fullyQualifiedName);
    }

    @Override
    public GeneratedClassHolder getGeneratedClassHolder(Element element) {
        return this.processHolder.getGeneratedClassHolder(element);
    }

    @Override
    public ProcessHolder.Classes getClasses() {
        return this.processHolder.classes();
    }

    @Override
    public List<Class<? extends Annotation>> getGeneratingAnnotations() {
        return this.annotationHandlers.getGeneratingAnnotations();
    }

    @Override
    public boolean isAndroidAnnotation(String annotationQualifiedName) {
        return this.getSupportedAnnotationTypes().contains(annotationQualifiedName);
    }

    @Override
    public List<AndroidAnnotationsPlugin> getPlugins() {
        return this.plugins;
    }
}

