/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.androidannotations.handler.AnnotationHandler;
import org.androidannotations.handler.GeneratingAnnotationHandler;
import org.androidannotations.handler.HasParameterHandlers;

public class AnnotationHandlers {
    private List<AnnotationHandler<?>> annotationHandlers = new ArrayList();
    private List<GeneratingAnnotationHandler<?>> generatingAnnotationHandlers = new ArrayList();
    private List<AnnotationHandler<?>> decoratingAnnotationHandlers = new ArrayList();
    private Set<String> supportedAnnotationNames;

    public void add(AnnotationHandler<?> annotationHandler) {
        this.annotationHandlers.add(annotationHandler);
        if (annotationHandler instanceof GeneratingAnnotationHandler) {
            this.generatingAnnotationHandlers.add((GeneratingAnnotationHandler)annotationHandler);
        } else {
            this.decoratingAnnotationHandlers.add(annotationHandler);
        }
        this.addParameterHandlers(annotationHandler);
    }

    private void addParameterHandlers(AnnotationHandler<?> annotationHandler) {
        if (annotationHandler instanceof HasParameterHandlers) {
            HasParameterHandlers hasParameterHandlers = (HasParameterHandlers)annotationHandler;
            for (AnnotationHandler parameterHandler : hasParameterHandlers.getParameterHandlers()) {
                this.add(parameterHandler);
            }
        }
    }

    public List<AnnotationHandler<?>> get() {
        return this.annotationHandlers;
    }

    public List<GeneratingAnnotationHandler<?>> getGenerating() {
        return this.generatingAnnotationHandlers;
    }

    public List<AnnotationHandler<?>> getDecorating() {
        return this.decoratingAnnotationHandlers;
    }

    public Set<String> getSupportedAnnotationTypes() {
        if (this.supportedAnnotationNames == null) {
            HashSet<String> annotationNames = new HashSet<String>();
            for (AnnotationHandler<?> annotationHandler : this.annotationHandlers) {
                annotationNames.add(annotationHandler.getTarget());
            }
            this.supportedAnnotationNames = Collections.unmodifiableSet(annotationNames);
        }
        return this.supportedAnnotationNames;
    }

    public List<Class<? extends Annotation>> getGeneratingAnnotations() {
        ArrayList<Class<? extends Annotation>> generatingAnnotations = new ArrayList<Class<? extends Annotation>>();
        for (GeneratingAnnotationHandler<?> generatingAnnotationHandler : this.getGenerating()) {
            try {
                generatingAnnotations.add(Class.forName(generatingAnnotationHandler.getTarget()));
            }
            catch (ClassCastException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return generatingAnnotations;
    }
}

